/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class Document {
    protected String id;
    protected String content;
    protected final Map<String, Object> metadata;
    protected transient double score;
    private float[] embedding;

    public Document() {
        this("");
    }

    public Document(String content) {
        this(content, null);
    }

    public Document(String content, Map<String, Object> metadata) {
        this(null, content, metadata, 0.0);
    }

    public Document(String id, String content, Map<String, Object> metadata, double score) {
        this.id = id;
        this.content = content;
        this.metadata = metadata == null ? new HashMap() : metadata;
        this.score = score;
    }

    public Document id(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Document content(String content) {
        this.content = content;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public Document embedding(float[] embedding) {
        this.embedding = embedding;
        return this;
    }

    public float[] getEmbedding() {
        return this.embedding;
    }

    public double getScore() {
        return this.score;
    }

    public Document score(double score) {
        this.score = score;
        return this;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Document{id='" + this.id + '\'' + ", score=" + this.score + ", content='" + this.content + '\'' + ", metadata=" + this.metadata + '}';
    }

    public Document metadata(String key, Object value) {
        if (value != null) {
            this.metadata.put(key, value);
        }
        return this;
    }

    public Document metadata(Map<String, Object> metadata) {
        this.metadata.putAll(metadata);
        return this;
    }

    public Object getMetadata(String key) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(key);
    }

    public Document title(String title) {
        return this.metadata("title", title);
    }

    public String getTitle() {
        return (String)this.getMetadata("title");
    }

    public Document url(String url) {
        return this.metadata("url", url);
    }

    public String getUrl() {
        return (String)this.getMetadata("url");
    }

    public Document summary(String summary) {
        return this.metadata("summary", summary);
    }

    public String getSummary() {
        return (String)this.getMetadata("summary");
    }
}

