/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.audio;

import java.util.Base64;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;

public class Audio
implements AiMedia {
    private String url;
    private String b64_json;
    private String mime;

    public static Audio ofUrl(String url) {
        Audio tmp = new Audio();
        tmp.url = url;
        return tmp;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "Audio{url='" + this.url + '\'' + ", b64_json='" + this.b64_json + '\'' + ", mime='" + this.mime + '\'' + '}';
    }

    public static Audio ofBase64(String base64String) {
        Audio tmp = new Audio();
        tmp.b64_json = base64String;
        return tmp;
    }

    public static Audio ofBase64(String base64String, String mime) {
        Audio tmp = new Audio();
        tmp.b64_json = base64String;
        tmp.mime = mime;
        return tmp;
    }

    public static Audio ofBase64(byte[] base64, String mime) {
        Audio tmp = new Audio();
        tmp.b64_json = Base64.getEncoder().encodeToString(base64);
        tmp.mime = mime;
        return tmp;
    }

    public static Audio ofBase64(byte[] base64) {
        Audio tmp = new Audio();
        tmp.b64_json = Base64.getEncoder().encodeToString(base64);
        return tmp;
    }

    @Override
    public String toDataString(boolean useMime) {
        if (Utils.isEmpty((String)this.b64_json)) {
            return this.url;
        }
        if (useMime) {
            if (this.mime != null) {
                return "data:" + this.mime + ";base64," + this.b64_json;
            }
            return "data:audio/mpeg;base64," + this.b64_json;
        }
        return this.b64_json;
    }
}

