/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.ChatChoice;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatException;
import org.noear.solon.ai.chat.ChatOptions;
import org.noear.solon.ai.chat.ChatRequest;
import org.noear.solon.ai.chat.ChatResponse;
import org.noear.solon.ai.chat.ChatResponseDefault;
import org.noear.solon.ai.chat.dialect.ChatDialect;
import org.noear.solon.ai.chat.function.ChatFunction;
import org.noear.solon.ai.chat.function.ChatFunctionCall;
import org.noear.solon.ai.chat.function.ChatFunctionParam;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.rx.SimpleSubscription;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatRequestDefault
implements ChatRequest {
    private static final Logger log = LoggerFactory.getLogger(ChatRequestDefault.class);
    private static final ChatOptions OPTIONS_DEFAULT = new ChatOptions();
    private final ChatConfig config;
    private final ChatDialect dialect;
    private final List<ChatMessage> messages;
    private ChatOptions options;

    public ChatRequestDefault(ChatConfig config, ChatDialect dialect, List<ChatMessage> messages) {
        this.config = config;
        this.dialect = dialect;
        this.messages = messages;
        this.options = OPTIONS_DEFAULT;
    }

    @Override
    public ChatRequest options(ChatOptions options) {
        if (options != null) {
            this.options = options;
        }
        return this;
    }

    @Override
    public ChatRequest options(Consumer<ChatOptions> optionsBuilder) {
        this.options = ChatOptions.of();
        optionsBuilder.accept(this.options);
        return this;
    }

    @Override
    public ChatResponse call() throws IOException {
        AssistantMessage choiceMessage;
        HttpUtils httpUtils = this.config.createHttpUtils();
        String reqJson = this.dialect.buildRequestJson(this.config, this.options, this.messages, false);
        if (log.isTraceEnabled()) {
            log.trace("ai-request: {}", (Object)reqJson);
        }
        String respJson = httpUtils.bodyOfJson(reqJson).post();
        if (log.isTraceEnabled()) {
            log.trace("ai-response: {}", (Object)respJson);
        }
        ChatResponseDefault resp = new ChatResponseDefault(false);
        this.dialect.parseResponseJson(this.config, resp, respJson);
        if (resp.getError() != null) {
            throw resp.getError();
        }
        if (resp.hasChoices() && Utils.isNotEmpty((choiceMessage = resp.getMessage()).getToolCalls())) {
            this.messages.add(choiceMessage);
            this.buildToolMessage(choiceMessage);
            return this.call();
        }
        return resp;
    }

    @Override
    public Publisher<ChatResponse> stream() {
        HttpUtils httpUtils = this.config.createHttpUtils();
        String reqJson = this.dialect.buildRequestJson(this.config, this.options, this.messages, true);
        if (log.isTraceEnabled()) {
            log.trace("ai-request: {}", (Object)reqJson);
        }
        return subscriber -> httpUtils.bodyOfJson(reqJson).execAsync("POST").whenComplete((resp, err) -> {
            if (err == null) {
                try {
                    this.parseResp((HttpResponse)resp, (Subscriber<? super ChatResponse>)subscriber);
                }
                catch (IOException e) {
                    subscriber.onError((Throwable)e);
                }
            } else {
                subscriber.onError(err);
            }
        });
    }

    private void parseResp(HttpResponse httpResp, Subscriber<? super ChatResponse> subscriber) throws IOException {
        ChatResponseDefault resp = new ChatResponseDefault(true);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(httpResp.body()));){
            subscriber.onSubscribe((Subscription)new SimpleSubscription().onRequest((subscription, l) -> {
                try {
                    String respJson;
                    while (l > 0L && !subscription.isCancelled() && (respJson = reader.readLine()) != null) {
                        if (respJson.length() == 0) continue;
                        if (log.isTraceEnabled()) {
                            log.trace("ai-response: {}", (Object)respJson);
                        }
                        resp.reset();
                        if (!this.dialect.parseResponseJson(this.config, resp, respJson)) continue;
                        if (resp.getError() != null) {
                            subscriber.onError((Throwable)((Object)resp.getError()));
                            return;
                        }
                        if (resp.hasChoices()) {
                            AssistantMessage choiceMessage = resp.getMessage();
                            if (Utils.isNotEmpty(choiceMessage.getToolCalls())) {
                                this.messages.add(choiceMessage);
                                this.buildToolMessage(choiceMessage);
                                reader.readLine();
                                this.stream().subscribe(subscriber);
                                return;
                            }
                            if (choiceMessage != null) {
                                if (resp.getChoices().size() > 1) {
                                    ArrayList<ChatChoice> choices = new ArrayList<ChatChoice>(resp.getChoices());
                                    for (ChatChoice choice : choices) {
                                        resp.reset();
                                        resp.addChoice(choice);
                                        subscriber.onNext((Object)resp);
                                        this.publishResponse(subscriber, resp, choice);
                                    }
                                } else {
                                    this.publishResponse(subscriber, resp, resp.getChoices().get(0));
                                }
                            }
                        }
                        if (resp.isFinished()) {
                            subscriber.onComplete();
                            break;
                        }
                        Long l2 = l;
                        Long l3 = l = Long.valueOf(l - 1L);
                    }
                }
                catch (Throwable err) {
                    subscriber.onError(err);
                }
            }));
        }
    }

    private void publishResponse(Subscriber<? super ChatResponse> subscriber, ChatResponseDefault resp, ChatChoice choice) {
        resp.aggregationMessageContent.append(choice.getMessage().getContent());
        subscriber.onNext((Object)resp);
    }

    private void buildToolMessage(AssistantMessage acm) throws ChatException {
        if (Utils.isEmpty(acm.getToolCalls())) {
            return;
        }
        for (ChatFunctionCall call : acm.getToolCalls()) {
            ChatFunction func = this.config.getGlobalFunction(call.name());
            if (func == null) {
                func = this.options.function(call.name());
            }
            if (func != null) {
                try {
                    String content = this.callFunction(func, call.arguments());
                    this.messages.add(ChatMessage.ofTool(content, call.name(), call.id()));
                    continue;
                }
                catch (Throwable ex) {
                    throw new ChatException("The function call failed!", ex);
                }
            }
            log.warn("tool call \u540d\u79f0 {} \u4e0d\u5b58\u5728", (Object)call.name());
        }
    }

    private String callFunction(ChatFunction func, Map<String, Object> args) throws Throwable {
        HashMap<String, Object> argsNew = new HashMap<String, Object>();
        ONode argsNode = ONode.load(args);
        for (ChatFunctionParam p1 : func.params()) {
            ONode v1 = argsNode.getOrNull(p1.name());
            if (v1 == null) {
                argsNew.put(p1.name(), null);
                continue;
            }
            argsNew.put(p1.name(), v1.toObject(p1.type()));
        }
        return func.handle(argsNew);
    }
}

