/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.image.dialect;

import java.util.List;
import org.noear.snack.ONode;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.image.Image;
import org.noear.solon.ai.image.ImageConfig;
import org.noear.solon.ai.image.ImageException;
import org.noear.solon.ai.image.ImageResponse;
import org.noear.solon.ai.image.dialect.AbstractImageDialect;

public class OllamaImageDialect
extends AbstractImageDialect {
    private static OllamaImageDialect instance = new OllamaImageDialect();

    public static OllamaImageDialect getInstance() {
        return instance;
    }

    @Override
    public boolean matched(ImageConfig config) {
        return "ollama".equals(config.getProvider());
    }

    @Override
    public ImageResponse parseResponseJson(ImageConfig config, String respJson) {
        ONode oResp = ONode.load((Object)respJson);
        String model = oResp.get("model").getString();
        if (oResp.contains("error")) {
            return new ImageResponse(model, new ImageException(oResp.get("error").getString()), null, null);
        }
        List data = oResp.get("data").toObjectList(Image.class);
        AiUsage usage = null;
        if (oResp.contains("prompt_eval_count")) {
            int prompt_eval_count = oResp.get("prompt_eval_count").getInt();
            usage = new AiUsage(prompt_eval_count, 0L, prompt_eval_count);
        }
        return new ImageResponse(model, null, data, usage);
    }
}

