/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ListUtil {
    public static <T> List<List<T>> partition(List<T> list) {
        return ListUtil.partition(list, 20);
    }

    public static <T> List<List<T>> partition(List<T> list, int pageSize) {
        if (list.size() <= pageSize) {
            return Arrays.asList(list);
        }
        int pageCount = list.size() / pageSize;
        int pageLastSize = list.size() % pageSize;
        if (pageLastSize > 0) {
            ++pageCount;
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (int i = 0; i < pageCount; ++i) {
            List<T> subList;
            int start = i * pageSize;
            if (i == pageCount - 1 && pageLastSize > 0) {
                subList = list.subList(start, start + pageLastSize);
                result.add(subList);
                break;
            }
            subList = list.subList(start, start + pageSize);
            result.add(subList);
        }
        return result;
    }
}

