/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.net.http.HttpUtils;

public class AiConfig {
    protected String apiUrl;
    protected String apiKey;
    protected String provider;
    protected String model;
    protected final Map<String, String> headers = new LinkedHashMap<String, String>();
    protected Duration timeout = Duration.ofSeconds(60L);

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getModel() {
        return this.model;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setTimeout(Duration timeout) {
        if (timeout != null) {
            this.timeout = timeout;
        }
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public HttpUtils createHttpUtils() {
        HttpUtils httpUtils = HttpUtils.http((String)this.getApiUrl()).timeout((int)this.getTimeout().getSeconds());
        if (Utils.isNotEmpty((String)this.getApiKey())) {
            httpUtils.header("Authorization", "Bearer " + this.getApiKey());
        }
        httpUtils.headers(this.getHeaders());
        return httpUtils;
    }
}

