/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.noear.solon.ai.chat.annotation.FunctionMapping;
import org.noear.solon.ai.chat.function.ChatFunction;
import org.noear.solon.ai.chat.function.ChatFunctionDecl;
import org.noear.solon.ai.chat.function.MethodChatFunction;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class ChatOptions {
    public static final String MAX_TOKENS = "max_tokens";
    public static final String MAX_COMPLETION_TOKENS = "max_completion_tokens";
    public static final String TEMPERATURE = "temperature";
    public static final String TOP_P = "top_p";
    public static final String TOP_K = "top_k";
    public static final String FREQUENCY_PENALTY = "frequency_penalty";
    public static final String PRESENCE_PENALTY = "presence_penalty";
    public static final String TOOL_CHOICE = "tool_choice";
    private final Map<String, ChatFunction> functions = new LinkedHashMap<String, ChatFunction>();
    private Map<String, Object> options = new LinkedHashMap<String, Object>();

    public static ChatOptions of() {
        return new ChatOptions();
    }

    public Collection<ChatFunction> functions() {
        return this.functions.values();
    }

    public ChatFunction function(String name) {
        return this.functions.get(name);
    }

    public ChatOptions functionAdd(Object functionObj) {
        return this.functionAdd(functionObj.getClass(), functionObj);
    }

    public ChatOptions functionAdd(Class<?> functionClz, Object functionObj) {
        if (functionObj instanceof ChatFunction) {
            ChatFunction func = (ChatFunction)functionObj;
            this.functions.put(func.name(), func);
        } else {
            int count = 0;
            for (Method method : functionClz.getMethods()) {
                if (!method.isAnnotationPresent(FunctionMapping.class)) continue;
                MethodChatFunction func = new MethodChatFunction(functionObj, method);
                this.functions.put(func.name(), func);
                ++count;
            }
            if (count == 0) {
                throw new IllegalArgumentException("This functionBean is not ChatFunction");
            }
        }
        return this;
    }

    public ChatOptions functionAdd(String name, Consumer<ChatFunctionDecl> functionBuilder) {
        ChatFunctionDecl decl = new ChatFunctionDecl(name);
        functionBuilder.accept(decl);
        this.functionAdd(decl);
        return this;
    }

    public Map<String, Object> options() {
        return this.options;
    }

    public Object option(String key) {
        return this.options.get(key);
    }

    public ChatOptions optionAdd(String key, Object val) {
        this.options.put(key, val);
        return this;
    }

    public ChatOptions function_choice(String choiceOrName) {
        if (choiceOrName == null) {
            this.optionAdd(TOOL_CHOICE, "none");
        } else if ("none".equals(choiceOrName)) {
            this.optionAdd(TOOL_CHOICE, "none");
        } else if ("auto".equals(choiceOrName)) {
            this.optionAdd(TOOL_CHOICE, "auto");
        } else if ("required".equals(choiceOrName)) {
            this.optionAdd(TOOL_CHOICE, "required");
        } else {
            HashMap<String, Object> choiceMap = new HashMap<String, Object>();
            choiceMap.put("type", "function");
            choiceMap.put("function", Collections.singletonMap("name", choiceOrName));
            this.optionAdd(TOOL_CHOICE, choiceMap);
        }
        return this;
    }

    public ChatOptions max_tokens(long max_tokens) {
        return this.optionAdd(MAX_TOKENS, max_tokens);
    }

    public ChatOptions max_completion_tokens(long max_completion_tokens) {
        return this.optionAdd(MAX_COMPLETION_TOKENS, max_completion_tokens);
    }

    public ChatOptions temperature(float temperature) {
        return this.optionAdd(TEMPERATURE, Float.valueOf(temperature));
    }

    public ChatOptions top_p(float top_p) {
        return this.optionAdd(TOP_P, Float.valueOf(top_p));
    }

    public ChatOptions top_k(float top_k) {
        return this.optionAdd(TOP_K, Float.valueOf(top_k));
    }

    public ChatOptions frequency_penalty(float frequency_penalty) {
        return this.optionAdd(FREQUENCY_PENALTY, Float.valueOf(frequency_penalty));
    }

    public ChatOptions presence_penalty(float frequency_penalty) {
        return this.optionAdd(PRESENCE_PENALTY, Float.valueOf(frequency_penalty));
    }

    public ChatOptions user(String user) {
        return this.optionAdd("user", user);
    }
}

