/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public interface ChatSession {
    public String getSessionId();

    public List<ChatMessage> getMessages();

    public void addMessage(ChatMessage ... var1);

    public void clear();

    default public String toNdjson() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.toNdjson(out);
        return new String(out.toByteArray(), Solon.encoding());
    }

    default public void toNdjson(OutputStream out) throws IOException {
        for (ChatMessage msg : this.getMessages()) {
            out.write(ChatMessage.toJson(msg).getBytes(Solon.encoding()));
            out.write("\n".getBytes(Solon.encoding()));
            out.flush();
        }
    }

    default public void loadNdjson(String ndjson) throws IOException {
        this.loadNdjson(new ByteArrayInputStream(ndjson.getBytes(Solon.encoding())));
    }

    default public void loadNdjson(InputStream ins) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ins));){
            String json;
            while (!Utils.isEmpty((String)(json = reader.readLine()))) {
                this.addMessage(ChatMessage.fromJson(json));
            }
        }
    }
}

