/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.message;

import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.message.ChatMessageBase;
import org.noear.solon.ai.chat.tool.ToolCall;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class AssistantMessage
extends ChatMessageBase<AssistantMessage> {
    private final ChatRole role = ChatRole.ASSISTANT;
    private String content;
    private List<ToolCall> toolCalls;
    private List<Map> toolCallsRaw;
    private boolean isThinking;
    private transient String resultContent;

    public AssistantMessage() {
    }

    public AssistantMessage(String content, boolean isThinking, List<Map> toolCallsRaw, List<ToolCall> toolCalls) {
        this.content = content;
        this.isThinking = isThinking;
        this.toolCallsRaw = toolCallsRaw;
        this.toolCalls = toolCalls;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public String getResultContent() {
        if (this.resultContent == null) {
            int tinkIndex;
            this.resultContent = this.content == null ? "" : ((tinkIndex = this.content.indexOf("</think>")) > 0 ? this.content.substring(tinkIndex + 8).trim() : this.content);
        }
        return this.resultContent;
    }

    @Override
    public boolean isThinking() {
        return this.isThinking;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public List<Map> getToolCallsRaw() {
        return this.toolCallsRaw;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("role=").append(this.getRole().name().toLowerCase());
        if (this.content != null) {
            buf.append(", content='").append(this.content).append('\'');
        }
        if (Utils.isNotEmpty((Map)this.metadata)) {
            buf.append(", metadata=").append(this.metadata);
        }
        if (this.toolCallsRaw != null) {
            buf.append(", tool_calls=").append(this.toolCallsRaw);
        }
        buf.append("}");
        return buf.toString();
    }
}

