/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.tool;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.annotation.ToolMapping;
import org.noear.solon.ai.chat.annotation.ToolParam;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.FunctionToolParam;
import org.noear.solon.ai.chat.tool.FunctionToolParamDesc;
import org.noear.solon.ai.chat.tool.ToolSchemaUtil;

public class MethodFunctionTool
implements FunctionTool {
    private final Object target;
    private final Method method;
    private final String description;
    private final String name;
    private final List<FunctionToolParam> params = new ArrayList<FunctionToolParam>();

    public MethodFunctionTool(Object target, Method method) {
        this.target = target;
        this.method = method;
        ToolMapping m1Anno = method.getAnnotation(ToolMapping.class);
        this.name = Utils.annoAlias((String)m1Anno.name(), (String)method.getName());
        this.description = m1Anno.description();
        for (Parameter p1 : method.getParameters()) {
            ToolParam p1Anno = p1.getAnnotation(ToolParam.class);
            String name = Utils.annoAlias((String)p1Anno.name(), (String)p1.getName());
            this.params.add(new FunctionToolParamDesc(name, p1.getType(), p1Anno.required(), p1Anno.description()));
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    public List<FunctionToolParam> params() {
        return Collections.unmodifiableList(this.params);
    }

    @Override
    public ONode inputSchema() {
        return ToolSchemaUtil.buildToolParametersNode(this, this.params, new ONode());
    }

    @Override
    public String handle(Map<String, Object> args) throws Throwable {
        HashMap<String, Object> argsNew = new HashMap<String, Object>();
        ONode argsNode = ONode.load(args);
        for (FunctionToolParam p1 : this.params()) {
            ONode v1 = argsNode.getOrNull(p1.name());
            if (v1 == null) {
                argsNew.put(p1.name(), null);
                continue;
            }
            argsNew.put(p1.name(), v1.toObject(p1.type()));
        }
        return this.doHandle(argsNew);
    }

    private String doHandle(Map<String, Object> args) throws Throwable {
        Object[] vals = new Object[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            vals[i] = args.get(this.params.get(i).name());
        }
        Object rst = this.method.invoke(this.target, vals);
        return String.valueOf(rst);
    }
}

