/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.noear.solon.ai.AiModel;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatRequest;
import org.noear.solon.ai.chat.ChatRequestDefault;
import org.noear.solon.ai.chat.ChatSession;
import org.noear.solon.ai.chat.annotation.ToolMapping;
import org.noear.solon.ai.chat.dialect.ChatDialect;
import org.noear.solon.ai.chat.dialect.ChatDialectManager;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.FunctionToolDesc;
import org.noear.solon.ai.chat.tool.MethodFunctionTool;
import org.noear.solon.core.Props;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class ChatModel
implements AiModel {
    private final ChatConfig config;
    private final ChatDialect dialect;

    public ChatModel(Properties properties) {
        this((ChatConfig)Props.from((Properties)properties).bindTo((Object)new ChatConfig()));
    }

    public ChatModel(ChatConfig config) {
        this.dialect = ChatDialectManager.select(config);
        this.config = config;
    }

    public ChatRequest prompt(ChatSession session) {
        return this.prompt(session.getMessages());
    }

    public ChatRequest prompt(List<ChatMessage> messages) {
        return new ChatRequestDefault(this.config, this.dialect, messages);
    }

    public ChatRequest prompt(ChatMessage ... messages) {
        return this.prompt(new ArrayList<ChatMessage>(Arrays.asList(messages)));
    }

    public ChatRequest prompt(String content) {
        return this.prompt(ChatMessage.ofUser(content));
    }

    public static Builder of(ChatConfig config) {
        return new Builder(config);
    }

    public static Builder of(String apiUrl) {
        return new Builder(apiUrl);
    }

    public static class Builder {
        private final ChatConfig config;

        public Builder(String apiUrl) {
            this.config = new ChatConfig();
            this.config.setApiUrl(apiUrl);
        }

        public Builder(ChatConfig config) {
            this.config = config;
        }

        public Builder apiKey(String apiKey) {
            this.config.setApiKey(apiKey);
            return this;
        }

        public Builder provider(String provider) {
            this.config.setProvider(provider);
            return this;
        }

        public Builder model(String model) {
            this.config.setModel(model);
            return this;
        }

        public Builder headerSet(String key, String value) {
            this.config.setHeader(key, value);
            return this;
        }

        public Builder defaultToolsAdd(Collection<FunctionTool> toolColl) {
            for (FunctionTool f : toolColl) {
                this.config.addDefaultTools(f);
            }
            return this;
        }

        public Builder defaultToolsAdd(Object toolObj) {
            return this.defaultToolsAdd(toolObj.getClass(), toolObj);
        }

        public Builder defaultToolsAdd(Class<?> toolClz, Object toolObj) {
            if (toolObj instanceof FunctionTool) {
                FunctionTool func = (FunctionTool)toolObj;
                this.config.addDefaultTools(func);
            } else {
                int count = 0;
                for (Method method : toolClz.getMethods()) {
                    if (!method.isAnnotationPresent(ToolMapping.class)) continue;
                    MethodFunctionTool func = new MethodFunctionTool(toolObj, method);
                    this.config.addDefaultTools(func);
                    ++count;
                }
                if (count == 0) {
                    throw new IllegalArgumentException("This functionBean is not ChatFunction");
                }
            }
            return this;
        }

        public Builder defaultToolsAdd(String name, Consumer<FunctionToolDesc> toolBuilder) {
            FunctionToolDesc decl = new FunctionToolDesc(name);
            toolBuilder.accept(decl);
            this.defaultToolsAdd(decl);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.config.setTimeout(timeout);
            return this;
        }

        public ChatModel build() {
            return new ChatModel(this.config);
        }
    }
}

