/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.tool;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.FunctionToolDesc;
import org.noear.solon.ai.chat.tool.FunctionToolParam;

public class ToolSchemaUtil {
    public static final String TYPE_OBJECT = "object";
    public static final String TYPE_ARRAY = "array";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_NULL = "null";

    public static FunctionToolDesc parseToolParametersNode(FunctionToolDesc functionDecl, ONode parametersNode) {
        List requiredList = parametersNode.get("required").toObjectList(String.class);
        ONode propertiesNode = parametersNode.get("properties");
        for (Map.Entry entry : propertiesNode.obj().entrySet()) {
            ONode paramNode = (ONode)entry.getValue();
            String name = (String)entry.getKey();
            Class<?> type = ToolSchemaUtil.jsonTypeAsClass(paramNode);
            String desc = paramNode.get("description").getString();
            functionDecl.param(name, type, requiredList.contains(name), desc);
        }
        return functionDecl;
    }

    public static ONode buildToolParametersNode(FunctionTool func, List<FunctionToolParam> funcParams, ONode parametersNode) {
        parametersNode.set("type", (Object)TYPE_OBJECT);
        ONode requiredNode = new ONode(parametersNode.options()).asArray();
        parametersNode.getOrNew("properties").build(propertiesNode -> {
            for (FunctionToolParam fp : funcParams) {
                propertiesNode.getOrNew(fp.name()).build(paramNode -> ToolSchemaUtil.buildToolParamNode(fp, paramNode));
                if (!fp.required()) continue;
                requiredNode.add((Object)fp.name());
            }
        });
        parametersNode.set("required", (Object)requiredNode);
        return parametersNode;
    }

    public static void buildToolParamNode(FunctionToolParam funcParam, ONode paramNode) {
        String typeStr = funcParam.type().getSimpleName().toLowerCase();
        if (funcParam.type().isArray()) {
            paramNode.set("type", (Object)TYPE_ARRAY);
            String typeItemStr = typeStr.substring(0, typeStr.length() - 2);
            paramNode.getOrNew("items").set("type", (Object)ToolSchemaUtil.jsonTypeCorrection(typeItemStr));
        } else if (funcParam.type().isEnum()) {
            paramNode.set("type", (Object)TYPE_STRING);
            paramNode.getOrNew("enum").build(n7 -> {
                for (Object e : funcParam.type().getEnumConstants()) {
                    n7.add((Object)e.toString());
                }
            });
        } else if (Date.class.isAssignableFrom(funcParam.type())) {
            paramNode.set("type", (Object)TYPE_STRING);
            paramNode.set("format", (Object)"date");
        } else if (URI.class.isAssignableFrom(funcParam.type())) {
            paramNode.set("type", (Object)TYPE_STRING);
            paramNode.set("format", (Object)"uri");
        } else {
            paramNode.set("type", (Object)ToolSchemaUtil.jsonTypeCorrection(typeStr));
        }
        paramNode.set("description", (Object)funcParam.description());
    }

    public static Class<?> jsonTypeAsClass(ONode paramNode) {
        String typeStr;
        switch (typeStr = paramNode.get("type").getString()) {
            case "short": 
            case "integer": 
            case "int": 
            case "long": {
                return Long.class;
            }
            case "double": 
            case "float": 
            case "number": {
                return Double.class;
            }
            case "bool": 
            case "boolean": {
                return Boolean.class;
            }
            case "date": {
                return Date.class;
            }
            case "string": {
                ONode formatNode = paramNode.getOrNull("format");
                ONode enumNode = paramNode.getOrNull("enum");
                if (formatNode != null) {
                    if ("date".equals(formatNode.getString())) {
                        return Date.class;
                    }
                    if ("uri".equals(formatNode.getString())) {
                        return URI.class;
                    }
                } else if (enumNode != null && enumNode.isArray()) {
                    return String.class;
                }
                return String.class;
            }
            case "array": {
                String typeItemStr;
                switch (typeItemStr = ToolSchemaUtil.jsonTypeCorrection(paramNode.get("items").getString())) {
                    case "integer": {
                        return Long[].class;
                    }
                    case "number": {
                        return Double[].class;
                    }
                    case "boolean": {
                        return Boolean[].class;
                    }
                    case "string": {
                        return String[].class;
                    }
                }
                return Object[].class;
            }
        }
        return Object.class;
    }

    public static String jsonTypeCorrection(String typeStr) {
        switch (typeStr) {
            case "short": 
            case "integer": 
            case "int": 
            case "long": {
                return TYPE_INTEGER;
            }
            case "double": 
            case "float": 
            case "number": {
                return TYPE_NUMBER;
            }
            case "bool": 
            case "boolean": {
                return TYPE_BOOLEAN;
            }
            case "string": 
            case "date": {
                return TYPE_STRING;
            }
        }
        return typeStr;
    }
}

