/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.image.dialect;

import java.util.List;
import org.noear.snack.ONode;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.image.Image;
import org.noear.solon.ai.image.ImageConfig;
import org.noear.solon.ai.image.ImageException;
import org.noear.solon.ai.image.ImageResponse;
import org.noear.solon.ai.image.dialect.AbstractImageDialect;

public class OpenaiImageDialect
extends AbstractImageDialect {
    private static OpenaiImageDialect instance = new OpenaiImageDialect();

    public static OpenaiImageDialect getInstance() {
        return instance;
    }

    @Override
    public boolean matched(ImageConfig config) {
        return false;
    }

    @Override
    public ImageResponse parseResponseJson(ImageConfig config, String respJson) {
        ONode oResp = ONode.load((Object)respJson);
        String model = oResp.get("model").getString();
        if (oResp.contains("error")) {
            return new ImageResponse(model, new ImageException(oResp.get("error").getString()), null, null);
        }
        List data = oResp.get("data").toObjectList(Image.class);
        AiUsage usage = null;
        if (oResp.contains("usage")) {
            ONode oUsage = oResp.get("usage");
            usage = new AiUsage(oUsage.get("prompt_tokens").getInt(), 0L, oUsage.get("total_tokens").getInt());
        }
        return new ImageResponse(model, null, data, usage);
    }
}

