/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.reranking;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.reranking.RerankingConfig;
import org.noear.solon.ai.reranking.RerankingOptions;
import org.noear.solon.ai.reranking.RerankingResponse;
import org.noear.solon.ai.reranking.dialect.RerankingDialect;
import org.noear.solon.net.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RerankingRequest {
    private static final Logger log = LoggerFactory.getLogger(RerankingRequest.class);
    private static final RerankingOptions OPTIONS_DEFAULT = new RerankingOptions();
    private final RerankingConfig config;
    private final RerankingDialect dialect;
    private final String query;
    private final List<Document> documents;
    private RerankingOptions options;

    protected RerankingRequest(RerankingConfig config, RerankingDialect dialect, String query, List<Document> documents) {
        this.config = config;
        this.dialect = dialect;
        this.query = query;
        this.documents = documents;
        this.options = OPTIONS_DEFAULT;
    }

    public RerankingRequest options(RerankingOptions options) {
        if (options != null) {
            this.options = options;
        }
        return this;
    }

    public RerankingRequest options(Consumer<RerankingOptions> optionsBuilder) {
        this.options = RerankingOptions.of();
        optionsBuilder.accept(this.options);
        return this;
    }

    public RerankingResponse call() throws IOException {
        HttpUtils httpUtils = this.config.createHttpUtils();
        String reqJson = this.dialect.buildRequestJson(this.config, this.options, this.query, this.documents);
        if (log.isTraceEnabled()) {
            log.trace("ai-request: {}", (Object)reqJson);
        }
        String respJson = httpUtils.bodyOfJson(reqJson).post();
        if (log.isTraceEnabled()) {
            log.trace("ai-response: {}", (Object)respJson);
        }
        RerankingResponse resp = this.dialect.parseResponseJson(this.config, respJson);
        return resp;
    }
}

