/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.message;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.SystemMessage;
import org.noear.solon.ai.chat.message.ToolMessage;
import org.noear.solon.ai.chat.message.UserMessage;
import org.noear.solon.ai.chat.message.UserMessageTemplate;
import org.noear.solon.ai.image.Image;

public interface ChatMessage
extends Serializable {
    public ChatRole getRole();

    public String getContent();

    public Map<String, Object> getMetadata();

    public ChatMessage addMetadata(Map<String, Object> var1);

    public ChatMessage addMetadata(String var1, Object var2);

    default public boolean isThinking() {
        return false;
    }

    public static AssistantMessage ofAssistant(String content) {
        return new AssistantMessage(content, false, null, null);
    }

    public static ChatMessage ofSystem(String content) {
        return new SystemMessage(content);
    }

    public static ChatMessage ofUser(String content) {
        return new UserMessage(content, null);
    }

    public static ChatMessage ofUser(String content, List<AiMedia> medias) {
        return new UserMessage(content, medias);
    }

    public static ChatMessage ofUser(String content, AiMedia ... medias) {
        return new UserMessage(content, Arrays.asList(medias));
    }

    public static ChatMessage ofUser(String content, Image ... images) {
        return new UserMessage(content, Arrays.asList(images));
    }

    public static ChatMessage ofTool(String content, String name, String toolCallId) {
        return new ToolMessage(content, name, toolCallId);
    }

    public static ChatMessage augment(String message, Object context) {
        String newContent = String.format("%s\n\n Now: %s\n\n References: %s", message, LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME), context);
        return new UserMessage(newContent);
    }

    public static UserMessageTemplate template(String tmpl) {
        return new UserMessageTemplate(tmpl);
    }

    public static String toJson(ChatMessage message) {
        return ONode.load((Object)message, (Feature[])new Feature[]{Feature.EnumUsingName}).toJson();
    }

    public static ChatMessage fromJson(String json) {
        ONode oNode = ONode.loadStr((String)json);
        ChatRole role = ChatRole.valueOf(oNode.get("role").getString());
        if (role == ChatRole.TOOL) {
            return (ChatMessage)oNode.toObject(ToolMessage.class);
        }
        if (role == ChatRole.SYSTEM) {
            return (ChatMessage)oNode.toObject(SystemMessage.class);
        }
        if (role == ChatRole.USER) {
            return (ChatMessage)oNode.toObject(UserMessage.class);
        }
        return (ChatMessage)oNode.toObject(AssistantMessage.class);
    }
}

