/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.message;

import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.message.ChatMessageBase;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class UserMessage
extends ChatMessageBase<UserMessage> {
    private final ChatRole role = ChatRole.USER;
    private String content;
    private List<AiMedia> medias;

    public UserMessage() {
    }

    public UserMessage(String content) {
        this(content, null);
    }

    public UserMessage(String content, List<AiMedia> medias) {
        this.content = content;
        this.medias = medias;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public List<AiMedia> getMedias() {
        return this.medias;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("role=").append(this.getRole().name().toLowerCase());
        if (this.content != null) {
            buf.append(", content='").append(this.content).append('\'');
        }
        if (Utils.isNotEmpty((Map)this.metadata)) {
            buf.append(", metadata=").append(this.metadata);
        }
        if (Utils.isNotEmpty(this.medias)) {
            buf.append(", medias=").append(this.medias);
        }
        buf.append("}");
        return buf.toString();
    }
}

