/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.image.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.ai.image.ImageConfig;
import org.noear.solon.ai.image.dialect.DashscopeImageDialect;
import org.noear.solon.ai.image.dialect.ImageDialect;
import org.noear.solon.ai.image.dialect.OllamaImageDialect;
import org.noear.solon.ai.image.dialect.OpenaiImageDialect;
import org.noear.solon.core.util.RankEntity;

public class ImageDialectManager {
    private static List<RankEntity<ImageDialect>> dialects = new ArrayList<RankEntity<ImageDialect>>();

    public static ImageDialect select(ImageConfig config) {
        for (RankEntity<ImageDialect> d : dialects) {
            if (!((ImageDialect)d.target).matched(config)) continue;
            return (ImageDialect)d.target;
        }
        return OpenaiImageDialect.getInstance();
    }

    public static void register(ImageDialect dialect) {
        ImageDialectManager.register(dialect, 0);
    }

    public static void register(ImageDialect dialect, int index) {
        dialects.add((RankEntity<ImageDialect>)new RankEntity((Object)dialect, index));
        Collections.sort(dialects);
    }

    public static void unregister(ImageDialect dialect) {
        dialects.removeIf(rankEntity -> rankEntity.target == dialect);
    }

    static {
        ImageDialectManager.register(OllamaImageDialect.getInstance());
        ImageDialectManager.register(DashscopeImageDialect.getInstance());
    }
}

