/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.rag.util;

import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.rag.util.Freshness;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.snel.SnEL;

public class QueryCondition {
    public static final int DEFAULT_LIMIT = 4;
    public static final double DEFAULT_SIMILARITY_THRESHOLD = 0.4;
    private final String query;
    private Freshness freshness;
    private int limit = 4;
    private double similarityThreshold = 0.4;
    private Expression<Boolean> filterExpression;
    private boolean disableRefilter;

    public QueryCondition(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public Freshness getFreshness() {
        return this.freshness;
    }

    public int getLimit() {
        return this.limit;
    }

    public double getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public Expression<Boolean> getFilterExpression() {
        return this.filterExpression;
    }

    public boolean isDisableRefilter() {
        return this.disableRefilter;
    }

    public boolean doFilter(Document doc) {
        if (this.filterExpression == null) {
            return true;
        }
        return (Boolean)this.filterExpression.eval(doc.getMetadata());
    }

    public QueryCondition freshness(Freshness freshness) {
        this.freshness = freshness;
        return this;
    }

    public QueryCondition limit(int limit) {
        this.limit = limit;
        return this;
    }

    public QueryCondition filterExpression(Expression<Boolean> filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    public QueryCondition filterExpression(String filterExpression) {
        this.filterExpression = SnEL.parse((String)filterExpression);
        return this;
    }

    public QueryCondition similarityThreshold(double similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
        return this;
    }

    public QueryCondition disableRefilter(boolean disableRefilter) {
        this.disableRefilter = disableRefilter;
        return this;
    }
}

