/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.reranking;

import java.io.IOException;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.noear.solon.ai.AiModel;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.reranking.RerankingConfig;
import org.noear.solon.ai.reranking.RerankingRequest;
import org.noear.solon.ai.reranking.RerankingResponse;
import org.noear.solon.ai.reranking.dialect.RerankingDialect;
import org.noear.solon.ai.reranking.dialect.RerankingDialectManager;
import org.noear.solon.core.Props;
import org.noear.solon.lang.Preview;

@Preview(value="3.1")
public class RerankingModel
implements AiModel {
    private final RerankingConfig config;
    private final RerankingDialect dialect;

    public RerankingModel(Properties properties) {
        this((RerankingConfig)Props.from((Properties)properties).bindTo((Object)new RerankingConfig()));
    }

    public RerankingModel(RerankingConfig config) {
        this.dialect = RerankingDialectManager.select(config);
        this.config = config;
    }

    public List<Document> rerank(String query, List<Document> documents) throws IOException {
        RerankingResponse resp = this.input(query, documents).call();
        if (resp.getError() != null) {
            throw resp.getError();
        }
        int len = documents.size();
        for (int i = 0; i < len; ++i) {
            documents.get(i).score(resp.getResults().get(i).getRelevanceScore());
        }
        return documents.stream().sorted(Comparator.comparing(Document::getScore).reversed()).collect(Collectors.toList());
    }

    public RerankingRequest input(String query, List<Document> documents) {
        return new RerankingRequest(this.config, this.dialect, query, documents);
    }

    public static Builder of(RerankingConfig config) {
        return new Builder(config);
    }

    public static Builder of(String apiUrl) {
        return new Builder(apiUrl);
    }

    public static class Builder {
        private final RerankingConfig config;

        public Builder(String apiUrl) {
            this.config = new RerankingConfig();
            this.config.setApiUrl(apiUrl);
        }

        public Builder(RerankingConfig config) {
            this.config = config;
        }

        public Builder apiKey(String apiKey) {
            this.config.setApiKey(apiKey);
            return this;
        }

        public Builder provider(String provider) {
            this.config.setProvider(provider);
            return this;
        }

        public Builder model(String model) {
            this.config.setModel(model);
            return this;
        }

        public Builder headerSet(String key, String value) {
            this.config.setHeader(key, value);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.config.setTimeout(timeout);
            return this;
        }

        public RerankingModel build() {
            return new RerankingModel(this.config);
        }
    }
}

