/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.dialect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.audio.Audio;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatOptions;
import org.noear.solon.ai.chat.ChatResponseDefault;
import org.noear.solon.ai.chat.dialect.ChatDialect;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.message.SystemMessage;
import org.noear.solon.ai.chat.message.ToolMessage;
import org.noear.solon.ai.chat.message.UserMessage;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.ToolCall;
import org.noear.solon.ai.chat.tool.ToolCallBuilder;
import org.noear.solon.ai.image.Image;
import org.noear.solon.ai.video.Video;

public abstract class AbstractChatDialect
implements ChatDialect {
    protected void buildChatMessageNodeDo(ONode oNode, AssistantMessage msg) {
        oNode.set("role", (Object)msg.getRole().name().toLowerCase());
        oNode.set("content", (Object)msg.getResultContent());
        if (Utils.isNotEmpty(msg.getToolCallsRaw())) {
            oNode.set("tool_calls", (Object)ONode.load(msg.getToolCallsRaw()));
        }
    }

    protected void buildChatMessageNodeDo(ONode oNode, SystemMessage msg) {
        oNode.set("role", (Object)msg.getRole().name().toLowerCase());
        oNode.set("content", (Object)msg.getContent());
    }

    protected void buildChatMessageNodeDo(ONode oNode, ToolMessage msg) {
        oNode.set("role", (Object)msg.getRole().name().toLowerCase());
        oNode.set("content", (Object)msg.getContent());
        if (Utils.isNotEmpty((String)msg.getName())) {
            oNode.set("name", (Object)msg.getName());
        }
        if (Utils.isNotEmpty((String)msg.getToolCallId())) {
            oNode.set("tool_call_id", (Object)msg.getToolCallId());
        }
    }

    protected void buildChatMessageNodeDo(ONode oNode, UserMessage msg) {
        oNode.set("role", (Object)msg.getRole().name().toLowerCase());
        if (Utils.isEmpty(msg.getMedias())) {
            oNode.set("content", (Object)msg.getContent());
        } else {
            oNode.getOrNew("content").build(n1 -> {
                n1.addNew().set("type", (Object)"text").set("text", (Object)msg.getContent());
                for (AiMedia media : msg.getMedias()) {
                    if (media instanceof Image) {
                        n1.addNew().set("type", (Object)"image_url").getOrNew("image_url").set("url", (Object)media.toDataString(true));
                        continue;
                    }
                    if (media instanceof Audio) {
                        n1.addNew().set("type", (Object)"audio_url").getOrNew("audio_url").set("url", (Object)media.getUrl());
                        continue;
                    }
                    if (!(media instanceof Video)) continue;
                    n1.addNew().set("type", (Object)"video_url").getOrNew("video_url").set("url", (Object)media.getUrl());
                }
            });
        }
    }

    public ONode buildChatMessageNode(ChatMessage chatMessage) {
        ONode oNode = new ONode();
        if (chatMessage instanceof AssistantMessage) {
            this.buildChatMessageNodeDo(oNode, (AssistantMessage)chatMessage);
        } else if (chatMessage instanceof SystemMessage) {
            this.buildChatMessageNodeDo(oNode, (SystemMessage)chatMessage);
        } else if (chatMessage instanceof ToolMessage) {
            this.buildChatMessageNodeDo(oNode, (ToolMessage)chatMessage);
        } else if (chatMessage instanceof UserMessage) {
            this.buildChatMessageNodeDo(oNode, (UserMessage)chatMessage);
        } else {
            throw new IllegalArgumentException("Unsupported chat message type: " + chatMessage.getClass());
        }
        return oNode;
    }

    protected void buildReqToolsNode(ONode n, ChatConfig config, ChatOptions options, ChatMessage lastMessage) {
        this.buildReqToolsNodeDo(n, config.getDefaultTools());
        this.buildReqToolsNodeDo(n, options.tools());
    }

    protected void buildReqToolsNodeDo(ONode n, Collection<FunctionTool> tools) {
        if (Utils.isEmpty(tools)) {
            return;
        }
        n.getOrNew("tools").build(n1 -> {
            for (FunctionTool func : tools) {
                n1.addNew().build(n2 -> {
                    n2.set("type", (Object)"function");
                    n2.getOrNew("function").build(toolNode -> {
                        toolNode.set("name", (Object)func.name());
                        toolNode.set("description", (Object)func.description());
                        toolNode.set("parameters", (Object)func.inputSchema());
                    });
                });
            }
        });
    }

    @Override
    public String buildRequestJson(ChatConfig config, ChatOptions options, List<ChatMessage> messages, boolean isStream) {
        return new ONode().build(n -> {
            if (Utils.isNotEmpty((String)config.getModel())) {
                n.set("model", (Object)config.getModel());
            }
            n.getOrNew("messages").build(n1 -> {
                for (ChatMessage m1 : messages) {
                    if (m1.isThinking()) continue;
                    n1.add((Object)this.buildChatMessageNode(m1));
                }
            });
            n.set("stream", (Object)isStream);
            for (Map.Entry<String, Object> kv : options.options().entrySet()) {
                n.set(kv.getKey(), kv.getValue());
            }
            ChatMessage lastMessage = (ChatMessage)messages.get(messages.size() - 1);
            this.buildReqToolsNode((ONode)n, config, options, lastMessage);
        }).toJson();
    }

    @Override
    public ONode buildAssistantMessageNode(Map<Integer, ToolCallBuilder> toolCallBuilders) {
        ONode oNode = new ONode();
        oNode.set("role", (Object)"assistant");
        oNode.set("content", (Object)"");
        oNode.getOrNew("tool_calls").asArray().build(n1 -> {
            for (Map.Entry kv : toolCallBuilders.entrySet()) {
                n1.addNew().set("id", (Object)((ToolCallBuilder)kv.getValue()).idBuilder.toString()).set("type", (Object)"function").getOrNew("function").build(n2 -> {
                    n2.set("name", (Object)((ToolCallBuilder)kv.getValue()).nameBuilder.toString());
                    n2.set("arguments", (Object)((ToolCallBuilder)kv.getValue()).argumentsBuilder.toString());
                });
            }
        });
        return oNode;
    }

    protected List<ToolCall> parseToolCalls(ONode toolCallsNode) {
        if (toolCallsNode == null) {
            return null;
        }
        ArrayList<ToolCall> toolCalls = new ArrayList<ToolCall>();
        for (ONode n1 : toolCallsNode.ary()) {
            toolCalls.add(this.parseToolCall(n1));
        }
        return toolCalls;
    }

    protected ToolCall parseToolCall(ONode n1) {
        int index = n1.get("index").getInt();
        String callId = n1.get("id").getString();
        ONode n1f = n1.get("function");
        String name = n1f.get("name").getString();
        ONode n1fArgs = n1f.get("arguments");
        String argStr = n1fArgs.getString();
        if (n1fArgs.isValue()) {
            n1fArgs = ONode.loadStr((String)argStr);
        }
        Map argMap = null;
        if (n1fArgs.isObject()) {
            argMap = (Map)n1fArgs.toObject(Map.class);
        }
        return new ToolCall(index, callId, name, argStr, argMap);
    }

    @Override
    public List<AssistantMessage> parseAssistantMessage(ChatResponseDefault resp, ONode oMessage) {
        ArrayList<AssistantMessage> messageList = new ArrayList<AssistantMessage>();
        String content = oMessage.get("content").getRawString();
        ONode toolCallsNode = oMessage.getOrNull("tool_calls");
        List toolCallsRaw = null;
        List<ToolCall> toolCalls = this.parseToolCalls(toolCallsNode);
        if (Utils.isNotEmpty(toolCalls)) {
            toolCallsRaw = (List)toolCallsNode.toObject(List.class);
        }
        if (oMessage.contains("reasoning_content")) {
            String reasoning_content = oMessage.get("reasoning_content").getRawString();
            if (resp.isStream()) {
                if (content == null) {
                    if (!resp.reasoning) {
                        messageList.add(new AssistantMessage("<think>", true, null, null));
                        messageList.add(new AssistantMessage("\n\n", true, null, null));
                        if (Utils.isNotEmpty((String)reasoning_content)) {
                            content = reasoning_content;
                        }
                    } else {
                        content = reasoning_content;
                    }
                    resp.reasoning = true;
                } else {
                    if (resp.reasoning) {
                        messageList.add(new AssistantMessage("</think>", true, null, null));
                        messageList.add(new AssistantMessage("\n\n", false, null, null));
                    }
                    resp.reasoning = false;
                }
            } else if (Utils.isNotEmpty((String)reasoning_content)) {
                content = "<think>\n\n" + reasoning_content + "</think>\n\n" + content;
            }
        } else if (content != null && resp.isStream()) {
            int thinkEnd;
            if (content.startsWith("<think>")) {
                resp.reasoning = true;
            } else if (resp.reasoning && (thinkEnd = content.indexOf("</think>")) >= 0) {
                resp.reasoning = false;
                messageList.add(new AssistantMessage(content, true, null, null));
                return messageList;
            }
        }
        if (content != null || toolCallsRaw != null) {
            messageList.add(new AssistantMessage(content, resp.reasoning, toolCallsRaw, toolCalls));
        }
        return messageList;
    }
}

