/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.embedding;

import java.util.Collections;
import java.util.List;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.embedding.Embedding;
import org.noear.solon.ai.embedding.EmbeddingException;
import org.noear.solon.lang.Nullable;

public class EmbeddingResponse {
    private final String model;
    private final EmbeddingException error;
    private final List<Embedding> data;
    private final AiUsage usage;

    public EmbeddingResponse(String model, EmbeddingException error, List<Embedding> data, AiUsage usage) {
        this.model = model;
        this.error = error;
        this.data = data;
        this.usage = usage;
        if (data != null) {
            Collections.sort(this.data);
        }
    }

    public String getModel() {
        return this.model;
    }

    @Nullable
    public EmbeddingException getError() {
        return this.error;
    }

    public List<Embedding> getData() {
        return this.data;
    }

    public AiUsage getUsage() {
        return this.usage;
    }

    public String toString() {
        return "{model='" + this.model + '\'' + ", data=" + this.data + ", usage=" + this.usage + '}';
    }
}

