/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.tool;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.ai.chat.annotation.ToolMapping;
import org.noear.solon.ai.chat.annotation.ToolMappingAnno;
import org.noear.solon.ai.chat.annotation.ToolParam;
import org.noear.solon.ai.chat.annotation.ToolParamAnno;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.FunctionToolParam;
import org.noear.solon.ai.chat.tool.FunctionToolParamDesc;
import org.noear.solon.ai.chat.tool.ToolCallResultConverter;
import org.noear.solon.ai.chat.tool.ToolSchemaUtil;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Param;
import org.noear.solon.core.util.Assert;

public class MethodFunctionTool
implements FunctionTool {
    private final Object target;
    private final Method method;
    private final String description;
    private boolean returnDirect;
    private final String name;
    private final List<FunctionToolParam> params = new ArrayList<FunctionToolParam>();
    private final ToolCallResultConverter resultConverter;

    public MethodFunctionTool(Object target, Method method) {
        this.target = target;
        this.method = method;
        ToolMapping m1Anno = method.getAnnotation(ToolMapping.class);
        if (m1Anno == null) {
            m1Anno = ToolMappingAnno.fromMapping(method.getAnnotation(Mapping.class));
        }
        this.name = Utils.annoAlias((String)m1Anno.name(), (String)method.getName());
        this.description = m1Anno.description();
        this.returnDirect = m1Anno.returnDirect();
        Assert.notEmpty((String)m1Anno.description(), (String)"ToolMapping description cannot be empty");
        this.resultConverter = m1Anno.resultConverter() == ToolCallResultConverter.class ? null : (ToolCallResultConverter)Solon.context().getBeanOrNew(m1Anno.resultConverter());
        for (Parameter p1 : method.getParameters()) {
            ToolParam p1Anno = p1.getAnnotation(ToolParam.class);
            if (p1Anno == null) {
                p1Anno = ToolParamAnno.fromMapping(p1.getAnnotation(Param.class));
            }
            Assert.notNull((Object)p1Anno, (String)"@ToolParam(or @Param) annotation is missing");
            Assert.notEmpty((String)p1Anno.description(), (String)"ToolParam description cannot be empty");
            String name = Utils.annoAlias((String)p1Anno.name(), (String)p1.getName());
            this.params.add(new FunctionToolParamDesc(name, p1.getType(), p1Anno.required(), p1Anno.description()));
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public boolean returnDirect() {
        return this.returnDirect;
    }

    public List<FunctionToolParam> params() {
        return Collections.unmodifiableList(this.params);
    }

    @Override
    public ONode inputSchema() {
        return ToolSchemaUtil.buildToolParametersNode(this, this.params, new ONode());
    }

    @Override
    public String handle(Map<String, Object> args) throws Throwable {
        HashMap<String, Object> argsNew = new HashMap<String, Object>();
        ONode argsNode = ONode.load(args);
        for (FunctionToolParam p1 : this.params()) {
            ONode v1 = argsNode.getOrNull(p1.name());
            if (v1 == null) {
                argsNew.put(p1.name(), null);
                continue;
            }
            argsNew.put(p1.name(), v1.toObject(p1.type()));
        }
        return this.doHandle(argsNew);
    }

    private String doHandle(Map<String, Object> args) throws Throwable {
        Object[] vals = new Object[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            vals[i] = args.get(this.params.get(i).name());
        }
        Object rst = this.method.invoke(this.target, vals);
        if (this.resultConverter == null) {
            return String.valueOf(rst);
        }
        return this.resultConverter.convert(rst);
    }

    public String toString() {
        return "MethodFunctionTool{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", returnDirect=" + this.returnDirect + ", inputSchema=" + this.inputSchema() + '}';
    }
}

