/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.chat.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.noear.snack.ONode;
import org.noear.solon.ai.chat.tool.FunctionTool;
import org.noear.solon.ai.chat.tool.FunctionToolParam;
import org.noear.solon.ai.chat.tool.FunctionToolParamDesc;
import org.noear.solon.ai.chat.tool.ToolSchemaUtil;

public class FunctionToolDesc
implements FunctionTool {
    private final String name;
    private final List<FunctionToolParam> params;
    private String description;
    private boolean returnDirect = false;
    private Function<Map<String, Object>, String> doHandle;

    public FunctionToolDesc(String name) {
        this.name = name;
        this.params = new ArrayList<FunctionToolParam>();
    }

    public FunctionToolDesc description(String description) {
        this.description = description;
        return this;
    }

    public FunctionToolDesc returnDirect(boolean returnDirect) {
        this.returnDirect = returnDirect;
        return this;
    }

    public FunctionToolDesc param(String name, Class<?> type, boolean required, String description) {
        this.params.add(new FunctionToolParamDesc(name, type, required, description));
        return this;
    }

    public FunctionToolDesc param(String name, Class<?> type, String description) {
        this.params.add(new FunctionToolParamDesc(name, type, true, description));
        return this;
    }

    public FunctionToolDesc stringParam(String name, String description) {
        return this.param(name, String.class, description);
    }

    public FunctionToolDesc intParam(String name, String description) {
        return this.param(name, Integer.TYPE, description);
    }

    public FunctionToolDesc floatParam(String name, String description) {
        return this.param(name, Float.TYPE, description);
    }

    public FunctionToolDesc boolParam(String name, String description) {
        return this.param(name, Boolean.class, description);
    }

    public FunctionToolDesc dateParam(String name, String description) {
        return this.param(name, Date.class, description);
    }

    public FunctionToolDesc doHandle(Function<Map<String, Object>, String> handler) {
        this.doHandle = handler;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public boolean returnDirect() {
        return this.returnDirect;
    }

    public List<FunctionToolParam> params() {
        return Collections.unmodifiableList(this.params);
    }

    @Override
    public ONode inputSchema() {
        return ToolSchemaUtil.buildToolParametersNode(this, this.params, new ONode());
    }

    @Override
    public String handle(Map<String, Object> args) throws Throwable {
        HashMap<String, Object> argsNew = new HashMap<String, Object>();
        ONode argsNode = ONode.load(args);
        for (FunctionToolParam p1 : this.params()) {
            ONode v1 = argsNode.getOrNull(p1.name());
            if (v1 == null) {
                argsNew.put(p1.name(), null);
                continue;
            }
            argsNew.put(p1.name(), v1.toObject(p1.type()));
        }
        return this.doHandle.apply(argsNew);
    }
}

