/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.image;

import java.io.IOException;
import java.util.function.Consumer;
import org.noear.solon.ai.image.ImageConfig;
import org.noear.solon.ai.image.ImageOptions;
import org.noear.solon.ai.image.ImageResponse;
import org.noear.solon.ai.image.dialect.ImageDialect;
import org.noear.solon.net.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRequest {
    private static final Logger log = LoggerFactory.getLogger(ImageRequest.class);
    private static final ImageOptions OPTIONS_DEFAULT = new ImageOptions();
    private final ImageConfig config;
    private final ImageDialect dialect;
    private final String prompt;
    private ImageOptions options;

    protected ImageRequest(ImageConfig config, ImageDialect dialect, String prompt) {
        this.config = config;
        this.dialect = dialect;
        this.prompt = prompt;
        this.options = OPTIONS_DEFAULT;
    }

    public ImageRequest options(ImageOptions options) {
        if (options != null) {
            this.options = options;
        }
        return this;
    }

    public ImageRequest options(Consumer<ImageOptions> optionsBuilder) {
        this.options = ImageOptions.of();
        optionsBuilder.accept(this.options);
        return this;
    }

    public ImageResponse call() throws IOException {
        HttpUtils httpUtils = this.config.createHttpUtils();
        String reqJson = this.dialect.buildRequestJson(this.config, this.options, this.prompt);
        if (log.isTraceEnabled()) {
            log.trace("ai-request: {}", (Object)reqJson);
        }
        String respJson = httpUtils.bodyOfJson(reqJson).post();
        if (log.isTraceEnabled()) {
            log.trace("ai-response: {}", (Object)respJson);
        }
        ImageResponse resp = this.dialect.parseResponseJson(this.config, respJson);
        return resp;
    }
}

