/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.integration;

import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.boot.prop.impl.WebSocketServerProps;
import org.noear.solon.boot.undertow.UndertowServer;
import org.noear.solon.boot.undertow.UndertowServerAddJsp;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;

public final class UndertowPlugin
implements Plugin {
    private static Signal _signal;
    private UndertowServer _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "undertow 2.2/" + Solon.version();
    }

    public void start(final AppContext context) throws Throwable {
        if (!context.app().enableHttp()) {
            return;
        }
        context.beanBuilderAdd(WebFilter.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebServlet.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebListener.class, (clz, bw, ano) -> {});
        if (context.isStarted()) {
            this.start0(context);
        } else {
            context.lifecycle(99, new LifecycleBean(){

                public void postStart() throws Throwable {
                    UndertowPlugin.this.start0(context);
                }
            });
        }
    }

    private void start0(AppContext context) throws Throwable {
        ServerProps.init();
        long time_start = System.currentTimeMillis();
        Class jspClz = ClassUtil.loadClass((String)"io.undertow.jsp.JspServletBuilder");
        HttpServerProps props = new HttpServerProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        this._server = jspClz == null ? new UndertowServer(props) : new UndertowServerAddJsp(props);
        this._server.enableWebSocket(context.app().enableWebSocket());
        EventBus.publish((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        context.app().signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "Connector:main: undertow: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (this._server.isSecure() && this._server.isEnableHttp2()) {
            connectorInfo = connectorInfo + ";HTTP/2,[http/2]";
        }
        if (context.app().enableWebSocket()) {
            WebSocketServerProps wsProps = WebSocketServerProps.getInstance();
            if (Utils.isNotEmpty((String)wsProps.getName())) {
                SignalSim wsSignal = new SignalSim(wsProps.getName(), _wrapHost, _wrapPort, "ws", SignalType.WEBSOCKET);
                context.app().signalAdd((Signal)wsSignal);
            }
            String wsServerUrl = props.buildWsServerUrl(this._server.isSecure());
            LogUtil.global().info(connectorInfo + "[WebSocket]}{" + wsServerUrl + "}");
        }
        String httpServerUrl = props.buildHttpServerUrl(this._server.isSecure());
        LogUtil.global().info(connectorInfo + "}{" + httpServerUrl + "}");
        LogUtil.global().info("Server:main: undertow: Started (" + UndertowPlugin.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            LogUtil.global().info("Server:main: undertow: Has Stopped (" + UndertowPlugin.solon_boot_ver() + ")");
        }
    }
}

