/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.web;

import java.io.IOException;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.http.HttpPartFile;
import org.noear.solon.boot.io.LimitedInputException;
import org.noear.solon.boot.io.LimitedInputStream;
import org.noear.solon.boot.web.uploadfile.HttpMultipart;
import org.noear.solon.boot.web.uploadfile.HttpMultipartCollection;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;

public class DecodeUtils {
    public static void decodeMultipart(Context ctx, MultiMap<UploadedFile> filesMap) {
        try {
            HttpMultipartCollection parts = new HttpMultipartCollection(ctx.contentType(), ctx.bodyAsStream());
            while (parts.hasNext()) {
                HttpMultipart part = parts.next();
                String name = ServerProps.urlDecode(part.getName());
                if (DecodeUtils.isFile(part)) {
                    DecodeUtils.doBuildFiles(name, filesMap, part);
                    continue;
                }
                ctx.paramMap().add(name, (Object)part.getString());
            }
        }
        catch (Exception e) {
            throw DecodeUtils.status4xx(ctx, e);
        }
    }

    private static void doBuildFiles(String name, MultiMap<UploadedFile> filesMap, HttpMultipart part) throws IOException {
        KeyValues list = filesMap.holder(name);
        String contentType = part.getHeaders().get("Content-Type");
        String filename = part.getFilename();
        String extension = null;
        int idx = filename.lastIndexOf(".");
        if (idx > 0) {
            extension = filename.substring(idx + 1);
        }
        HttpPartFile partFile = new HttpPartFile(filename, new LimitedInputStream(part.getBody(), ServerProps.request_maxFileSize));
        UploadedFile f1 = new UploadedFile(partFile::delete, contentType, partFile.getSize(), partFile.getContent(), filename, extension);
        list.addValue((Object)f1);
    }

    private static boolean isField(HttpMultipart filePart) {
        return filePart.getFilename() == null;
    }

    private static boolean isFile(HttpMultipart filePart) {
        return !DecodeUtils.isField(filePart);
    }

    public static void decodeFormUrlencoded(Context ctx) throws IOException {
        DecodeUtils.decodeFormUrlencoded(ctx, true);
    }

    public static void decodeFormUrlencoded(Context ctx, boolean excludePost) throws IOException {
        String[] ss;
        if (excludePost && MethodType.POST.name.equals(ctx.method())) {
            return;
        }
        if (!ctx.isFormUrlencoded()) {
            return;
        }
        if (Utils.isEmpty((String)ctx.bodyNew())) {
            return;
        }
        for (String s1 : ss = ctx.bodyNew().split("&")) {
            int idx = s1.indexOf(61);
            if (idx <= 0) continue;
            String name = ServerProps.urlDecode(s1.substring(0, idx));
            String value = ServerProps.urlDecode(s1.substring(idx + 1));
            ctx.paramMap().add(name, (Object)value);
        }
    }

    public static void decodeCookies(Context ctx, String cookies) {
        if (Utils.isEmpty((String)cookies)) {
            return;
        }
        DecodeUtils.decodeCookiesDo(ctx, cookies, 0);
    }

    private static void decodeCookiesDo(Context ctx, String cookies, int offset) {
        while (offset < cookies.length() && cookies.charAt(offset) == ' ') {
            ++offset;
        }
        int idx1 = cookies.indexOf("=", offset);
        if (idx1 < 0) {
            return;
        }
        String name = cookies.substring(offset, idx1);
        int idx2 = cookies.indexOf(";", idx1);
        if (idx2 < 0) {
            idx2 = cookies.length();
        }
        for (offset = idx2; offset > idx1 && cookies.charAt(offset - 1) == ' '; --offset) {
        }
        String value = cookies.substring(idx1 + 1, offset);
        ctx.cookieMap().add(name, (Object)value.trim());
        if (idx2 < 0) {
            return;
        }
        DecodeUtils.decodeCookiesDo(ctx, cookies, idx2 + 1);
    }

    public static int decodeContentLength(Context ctx) {
        long length = DecodeUtils.decodeContentLengthLong(ctx);
        return length > Integer.MAX_VALUE ? -1 : (int)length;
    }

    public static long decodeContentLengthLong(Context ctx) {
        String contentLength = ctx.header("Content-Length");
        return contentLength != null && !contentLength.isEmpty() ? Long.parseLong(contentLength) : -1L;
    }

    public static String extractQuotedValueFromHeader(String header, String key) {
        char c;
        int start;
        int i;
        if (Utils.isEmpty((String)header)) {
            return null;
        }
        int keypos = 0;
        int pos = -1;
        boolean whiteSpace = true;
        boolean inQuotes = false;
        for (i = 0; i < header.length() - 1; ++i) {
            start = header.charAt(i);
            if (inQuotes) {
                if (start != 34) continue;
                inQuotes = false;
                continue;
            }
            if (key.charAt(keypos) == start && (whiteSpace || keypos > 0)) {
                ++keypos;
                whiteSpace = false;
            } else if (start == 34) {
                keypos = 0;
                inQuotes = true;
                whiteSpace = false;
            } else {
                keypos = 0;
                boolean bl = whiteSpace = start == 32 || start == 59 || start == 9;
            }
            if (keypos != key.length()) continue;
            if (header.charAt(i + 1) == '=') {
                pos = i + 2;
                break;
            }
            keypos = 0;
        }
        if (pos == -1) {
            return null;
        }
        if (header.charAt(pos) == '\"') {
            char c2;
            for (i = start = pos + 1; i < header.length() && (c2 = header.charAt(i)) != '\"'; ++i) {
            }
            return header.substring(start, i);
        }
        for (i = pos; i < header.length() && (c = header.charAt(i)) != ' ' && c != '\t' && c != ';'; ++i) {
        }
        return header.substring(pos, i);
    }

    public static StatusException status4xx(Context ctx, Exception e) {
        if (e instanceof StatusException) {
            return (StatusException)e;
        }
        if (DecodeUtils.isBodyLargerEx(e)) {
            return new StatusException("Request Entity Too Large: " + ctx.method() + " " + ctx.pathNew(), (Throwable)e, 413);
        }
        return new StatusException("Bad Request:" + ctx.method() + " " + ctx.pathNew(), (Throwable)e, 400);
    }

    public static boolean isBodyLargerEx(Throwable e) {
        return DecodeUtils.hasLargerStr(e) || DecodeUtils.hasLargerStr(e.getCause());
    }

    private static boolean hasLargerStr(Throwable e) {
        return e instanceof LimitedInputException;
    }
}

