/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.prop;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.prop.ServerSslProps;

class ServerSslPropsImpl
implements ServerSslProps {
    private String PROP_SSL_ENABLE = "server.@@.ssl.enable";
    private String PROP_SSL_KEY_TYPE = "server.@@.ssl.keyType";
    private String PROP_SSL_KEY_STORE = "server.@@.ssl.keyStore";
    private String PROP_SSL_KEY_PASSWORK = "server.@@.ssl.keyPassword";
    private boolean enable;
    private String sslKeyType;
    private String sslKeyStore;
    private String sslKeyPassword;

    public ServerSslPropsImpl(String signalName) {
        this.PROP_SSL_KEY_STORE = this.PROP_SSL_KEY_STORE.replace("@@", signalName);
        this.PROP_SSL_ENABLE = this.PROP_SSL_ENABLE.replace("@@", signalName);
        this.sslKeyStore = Solon.cfg().getByKeys(new String[]{this.PROP_SSL_KEY_STORE, "server.ssl.keyStore"});
        this.enable = Solon.cfg().getBool(this.PROP_SSL_ENABLE, true);
        if (Utils.isNotEmpty((String)this.sslKeyStore)) {
            this.PROP_SSL_KEY_PASSWORK = this.PROP_SSL_KEY_PASSWORK.replace("@@", signalName);
            this.PROP_SSL_KEY_TYPE = this.PROP_SSL_KEY_TYPE.replace("@@", signalName);
            this.sslKeyType = Solon.cfg().getByKeys(new String[]{this.PROP_SSL_KEY_TYPE, "server.ssl.keyType"});
            this.sslKeyPassword = Solon.cfg().getByKeys(new String[]{this.PROP_SSL_KEY_PASSWORK, "server.ssl.keyPassword"});
        }
    }

    @Override
    public String getSslKeyType() {
        return this.sslKeyType;
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public String getSslKeyStore() {
        return this.sslKeyStore;
    }

    @Override
    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }
}

