/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.filter;

import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExFilterChain;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import org.noear.solon.rx.Completable;

public class AddRequestHeaderFilterFactory
implements RouteFilterFactory {
    @Override
    public String prefix() {
        return "AddRequestHeader";
    }

    @Override
    public ExFilter create(String config) {
        return new AddRequestHeaderFilter(config);
    }

    public static class AddRequestHeaderFilter
    implements ExFilter {
        private final String name;
        private final String value;

        public AddRequestHeaderFilter(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("AddRequestHeaderFilter config cannot be blank");
            }
            String[] parts = config.split(",");
            if (parts.length != 2) {
                throw new IllegalArgumentException("AddRequestHeaderFilter config is wrong: " + config);
            }
            this.name = parts[0];
            this.value = parts[1];
            if (Utils.isEmpty((String)this.name) || Utils.isEmpty((String)this.value)) {
                throw new IllegalArgumentException("AddRequestHeaderFilter config is wrong: " + config);
            }
        }

        @Override
        public Completable doFilter(ExContext ctx, ExFilterChain chain) {
            ctx.newRequest().headerAdd(this.name, this.value);
            return chain.doFilter(ctx);
        }
    }
}

