/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway;

import io.vertx.core.http.HttpServerRequest;
import java.util.concurrent.Executor;
import org.noear.solon.cloud.gateway.CloudGatewayCompletion;
import org.noear.solon.cloud.gateway.CloudGatewayConfiguration;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExContextImpl;
import org.noear.solon.cloud.gateway.exchange.ExFilterChainImpl;
import org.noear.solon.cloud.gateway.route.RouteFactoryManager;
import org.noear.solon.cloud.gateway.route.RouteHandler;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.rx.Completable;
import org.noear.solon.web.vertx.VxHandler;
import org.reactivestreams.Subscriber;

public class CloudGatewayHandler
implements VxHandler {
    private CloudGatewayConfiguration configuration = new CloudGatewayConfiguration();
    private VxHandler webHandler;

    public CloudGatewayHandler(VxHandler webHandler) {
        this.webHandler = webHandler;
    }

    public void setHandler(Handler handler) {
        this.webHandler.setHandler(handler);
    }

    public void setExecutor(Executor executor) {
        this.webHandler.setExecutor(executor);
    }

    public void handle(HttpServerRequest request) {
        ExContextImpl ctx = new ExContextImpl(request);
        ctx.bind(this.configuration.routeFind(ctx));
        if (ctx.route() == null) {
            this.webHandler.handle((Object)request);
        } else {
            CloudGatewayCompletion completion = new CloudGatewayCompletion(ctx, request);
            try {
                new ExFilterChainImpl(this.configuration.filters, this::doHandle).doFilter(ctx).subscribe((Subscriber)completion);
            }
            catch (Throwable ex) {
                if (ex instanceof StatusException) {
                    StatusException se = (StatusException)ex;
                    ctx.newResponse().status(se.getCode());
                } else {
                    ctx.newResponse().status(502);
                }
                completion.postComplete();
            }
        }
    }

    private Completable doHandle(ExContext ctx) {
        ExContextImpl ctx2 = (ExContextImpl)ctx;
        if (ctx2.route() == null) {
            ctx.newResponse().status(404);
            return Completable.complete();
        }
        RouteHandler handler = RouteFactoryManager.getHandler(ctx.targetNew().getScheme());
        if (handler == null) {
            throw new StatusException("The target handler does not exist", 404);
        }
        try {
            return new ExFilterChainImpl(ctx2.route().getFilters(), handler::handle).doFilter(ctx);
        }
        catch (Throwable ex) {
            if (ex instanceof StatusException) {
                return Completable.error((Throwable)ex);
            }
            return Completable.error((Throwable)new StatusException(ex, 400));
        }
    }

    public CloudGatewayConfiguration getConfiguration() {
        return this.configuration;
    }
}

