/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.predicate;

import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;

public class QueryPredicateFactory
implements RoutePredicateFactory {
    @Override
    public String prefix() {
        return "Query";
    }

    @Override
    public ExPredicate create(String config) {
        return new QueryPredicate(config);
    }

    private static class QueryPredicate
    implements ExPredicate {
        private String queryName;
        private Pattern pattern;

        public QueryPredicate(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("QueryPredicate config cannot be blank");
            }
            String[] parts = config.split(",");
            if (parts.length == 0) {
                throw new IllegalArgumentException("QueryPredicate config is wrong: " + config);
            }
            this.queryName = parts[0].trim();
            if (Utils.isEmpty((String)this.queryName)) {
                throw new IllegalArgumentException("Query name cannot be empty.");
            }
            if (parts.length > 1) {
                String regex = parts[1].trim();
                if (Utils.isEmpty((String)regex)) {
                    throw new IllegalArgumentException("Query regex cannot be empty.");
                }
                this.pattern = Pattern.compile(regex);
            }
        }

        @Override
        public boolean test(ExContext exContext) {
            String value = exContext.rawQueryParam(this.queryName);
            if (value == null) {
                return false;
            }
            if (this.pattern == null) {
                return true;
            }
            return this.pattern.matcher(value).find();
        }
    }
}

