/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.properties.TimeoutProperties;
import org.noear.solon.core.util.RankEntity;

public class Route
implements Comparable<Route> {
    protected final String id;
    protected int index;
    protected int depth;
    protected URI target;
    protected List<ExPredicate> predicates = new ArrayList<ExPredicate>();
    protected List<RankEntity<ExFilter>> filters = new ArrayList<RankEntity<ExFilter>>();
    protected TimeoutProperties timeout;

    public Route(String id) {
        this.id = id;
        if (Utils.isEmpty((String)id)) {
            throw new IllegalArgumentException("Gateway route id is empty");
        }
    }

    public boolean matched(ExContext ctx) {
        if (this.predicates.size() == 0) {
            return false;
        }
        for (ExPredicate p : this.predicates) {
            if (p.test(ctx)) continue;
            return false;
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public URI getTarget() {
        return this.target;
    }

    public List<ExPredicate> getPredicates() {
        return this.predicates;
    }

    public List<RankEntity<ExFilter>> getFilters() {
        return this.filters;
    }

    public TimeoutProperties getTimeout() {
        return this.timeout;
    }

    @Override
    public int compareTo(Route o) {
        if (this.index == o.index) {
            if (this.depth == o.depth) {
                return 0;
            }
            if (this.depth > o.depth) {
                return -1;
            }
            return 1;
        }
        if (this.index < o.index) {
            return -1;
        }
        return 1;
    }
}

