/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.filter;

import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExFilterChain;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import org.noear.solon.rx.Completable;

public class PrefixPathFilterFactory
implements RouteFilterFactory {
    @Override
    public String prefix() {
        return "PrefixPath";
    }

    @Override
    public ExFilter create(String config) {
        return new PrefixPathFilter(config);
    }

    public static class PrefixPathFilter
    implements ExFilter {
        private String part;

        public PrefixPathFilter(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("PrefixPathFilter config cannot be blank");
            }
            this.part = config.startsWith("/") ? config : "/" + config;
        }

        @Override
        public Completable doFilter(ExContext ctx, ExFilterChain chain) {
            String newPath = this.part + ctx.newRequest().getPath();
            ctx.newRequest().path(newPath);
            return chain.doFilter(ctx);
        }
    }
}

