/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.predicate;

import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;

public class CookiePredicateFactory
implements RoutePredicateFactory {
    @Override
    public String prefix() {
        return "Cookie";
    }

    @Override
    public ExPredicate create(String config) {
        return new CookiePredicate(config);
    }

    public static class CookiePredicate
    implements ExPredicate {
        private final String cookieName;
        private Pattern pattern;

        public CookiePredicate(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("CookiePredicate config cannot be blank");
            }
            String[] parts = config.split(",");
            if (parts.length == 0) {
                throw new IllegalArgumentException("CookiePredicate config format is wrong");
            }
            this.cookieName = parts[0].trim();
            if (Utils.isEmpty((String)this.cookieName)) {
                throw new IllegalArgumentException("Cookie name cannot be empty.");
            }
            if (parts.length > 1) {
                String regex = parts[1].trim();
                if (Utils.isEmpty((String)regex)) {
                    throw new IllegalArgumentException("Cookie regex cannot be empty.");
                }
                this.pattern = Pattern.compile(regex);
            }
        }

        @Override
        public boolean test(ExContext ctx) {
            String value = ctx.rawCookie(this.cookieName);
            if (value == null) {
                return false;
            }
            if (this.pattern == null) {
                return true;
            }
            return this.pattern.matcher(value).find();
        }
    }
}

