/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.predicate;

import java.time.ZonedDateTime;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.route.RoutePredicateFactory;

public class AfterPredicateFactory
implements RoutePredicateFactory {
    @Override
    public String prefix() {
        return "After";
    }

    @Override
    public ExPredicate create(String config) {
        return new AfterPredicate(config);
    }

    public static class AfterPredicate
    implements ExPredicate {
        private final ZonedDateTime dateTime;

        public AfterPredicate(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("AfterPredicate config cannot be blank");
            }
            this.dateTime = ZonedDateTime.parse(config);
        }

        @Override
        public boolean test(ExContext ctx) {
            return ZonedDateTime.now().isAfter(this.dateTime);
        }
    }
}

