/*
 * Copyright 2017-2025 noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.solon.cloud.gateway.route;


import org.noear.solon.cloud.gateway.exchange.ExPredicate;

/**
 * 路由检测器工厂
 *
 * @author noear
 * @since 2.9
 */
public interface RoutePredicateFactory {
    /**
     * 配置前缀
     */
    String prefix();

    /**
     * 创建
     */
    ExPredicate create(String config);
}
