/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.CloudRouteRegister;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.properties.GatewayProperties;
import org.noear.solon.cloud.gateway.properties.RouteProperties;
import org.noear.solon.cloud.gateway.route.Route;
import org.noear.solon.cloud.gateway.route.RouteFactoryManager;
import org.noear.solon.cloud.gateway.route.RouteSpec;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.util.RankEntity;

public class CloudGatewayConfiguration
implements CloudRouteRegister {
    protected final Map<String, RouteSpec> routes = new ConcurrentHashMap<String, RouteSpec>();
    protected final List<ExFilter> routeDefaultFilters = new ArrayList<ExFilter>();
    protected List<RankEntity<ExFilter>> filters = new ArrayList<RankEntity<ExFilter>>();

    public void filter(ExFilter filter) {
        this.filter(filter, 0);
    }

    public void filter(ExFilter filter, int index) {
        if (filter != null) {
            this.filters.add((RankEntity<ExFilter>)new RankEntity(filter::doFilter, index));
            this.filters.sort(Comparator.comparingInt(e -> e.index));
        }
    }

    public void routeDefaultFilter(ExFilter filter) {
        if (filter != null) {
            this.routeDefaultFilters.add(filter);
        }
    }

    @Override
    public CloudRouteRegister route(String id, Consumer<RouteSpec> builder) {
        RouteSpec route = this.routes.computeIfAbsent(id, k -> new RouteSpec(id).filters(this.routeDefaultFilters));
        builder.accept(route);
        return this;
    }

    @Override
    public CloudRouteRegister route(RouteSpec route) {
        if (route != null) {
            this.routes.put(route.getId(), route.filters(this.routeDefaultFilters));
        }
        return this;
    }

    @Override
    public CloudRouteRegister route(GatewayProperties gatewayProperties) {
        if (Utils.isEmpty(gatewayProperties.getRoutes())) {
            return this;
        }
        for (RouteProperties rm : gatewayProperties.getRoutes()) {
            RouteSpec route = new RouteSpec(rm.getId());
            route.index(rm.getIndex());
            route.target(URI.create(rm.getTarget()));
            if ("lb".equals(route.getTarget().getScheme())) {
                LoadBalance.get((String)route.getTarget().getHost());
            }
            if (rm.getPredicates() != null) {
                for (String predicateStr : rm.getPredicates()) {
                    route.predicate(RouteFactoryManager.buildPredicate(predicateStr));
                }
            }
            if (rm.getFilters() != null) {
                for (String filterStr : rm.getFilters()) {
                    route.filter(RouteFactoryManager.buildFilter(filterStr));
                }
            }
            if (rm.getTimeout() != null) {
                route.timeout(rm.getTimeout());
            } else {
                route.timeout(gatewayProperties.getHttpClient());
            }
            this.route(route);
        }
        return this;
    }

    @Override
    public CloudRouteRegister routeRemove(String id) {
        this.routes.remove(id);
        return this;
    }

    public Route routeFind(ExContext ctx) {
        ArrayList<RouteSpec> routeList = new ArrayList<RouteSpec>(this.routes.values());
        Collections.sort(routeList);
        for (Route route : routeList) {
            if (!route.matched(ctx)) continue;
            return route;
        }
        return null;
    }
}

