/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.filter;

import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExFilterChain;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import org.noear.solon.rx.Completable;

public class AddResponseHeaderFilterFactory
implements RouteFilterFactory {
    @Override
    public String prefix() {
        return "AddResponseHeader";
    }

    @Override
    public ExFilter create(String config) {
        return new AddResponseHeaderFilter(config);
    }

    public static class AddResponseHeaderFilter
    implements ExFilter {
        private final String name;
        private final String value;

        public AddResponseHeaderFilter(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("AddResponseHeaderFilter config cannot be blank");
            }
            String[] parts = config.split(",");
            if (parts.length != 2) {
                throw new IllegalArgumentException("AddResponseHeaderFilter config is wrong: " + config);
            }
            this.name = parts[0];
            this.value = parts[1];
            if (Utils.isEmpty((String)this.name) || Utils.isEmpty((String)this.value)) {
                throw new IllegalArgumentException("AddResponseHeaderFilter config is wrong: " + config);
            }
        }

        @Override
        public Completable doFilter(ExContext ctx, ExFilterChain chain) {
            return Completable.create(emitter -> chain.doFilter(ctx).doOnComplete(() -> {
                ctx.newResponse().headerAdd(this.name, this.value);
                emitter.onComplete();
            }).doOnError(err -> {
                ctx.newResponse().headerAdd(this.name, this.value);
                emitter.onError(err);
            }).subscribe());
        }
    }
}

