/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.tracing;

import io.opentracing.Tracer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.nami.NamiManager;
import org.noear.solon.Solon;
import org.noear.solon.cloud.tracing.annotation.Tracing;
import org.noear.solon.cloud.tracing.annotation.TracingInterceptor;
import org.noear.solon.cloud.tracing.integration.NamiFilterTracing;
import org.noear.solon.cloud.tracing.integration.SolonFilterTracing;
import org.noear.solon.cloud.tracing.service.TracerFactory;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.handle.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingManager {
    static final Logger log = LoggerFactory.getLogger(TracingManager.class);
    private static AtomicBoolean enabled = new AtomicBoolean(false);

    public static void enable(String excluded) {
        if (enabled.compareAndSet(false, true)) {
            NamiManager.reg((org.noear.nami.Filter)new NamiFilterTracing());
            Solon.app().filter((Filter)new SolonFilterTracing(excluded));
            Solon.context().beanInterceptorAdd(Tracing.class, (Interceptor)new TracingInterceptor());
        }
    }

    public static void register(TracerFactory service) {
        try {
            Solon.context().wrapAndPut(Tracer.class, (Object)service.create());
            log.info("Cloud: TracerFactory registered from the " + service.getClass().getTypeName());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

