/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.model;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.model.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventObserver
implements CloudEventHandler {
    private static Logger log = LoggerFactory.getLogger(EventObserver.class);
    private final EventLevel level;
    private final String group;
    private final String topic;
    private final String tag;
    private final int qos;
    private final List<CloudEventHandler> handlers;

    public EventObserver(EventLevel level, String group, String topic, String tag, int qos) {
        this.level = level;
        this.group = group;
        this.topic = topic;
        this.tag = tag;
        this.qos = qos;
        this.handlers = new ArrayList<CloudEventHandler>();
    }

    public EventLevel getLevel() {
        return this.level;
    }

    public String getGroup() {
        return this.group;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTag() {
        return this.tag;
    }

    public int getQos() {
        return this.qos;
    }

    public void addHandler(CloudEventHandler handler) {
        this.handlers.add(handler);
    }

    @Override
    public boolean handle(Event event) throws Throwable {
        boolean isOk = true;
        boolean isHandled = false;
        for (CloudEventHandler h1 : this.handlers) {
            isOk = isOk && this.handlerDo(event, h1);
            isHandled = true;
        }
        if (!isHandled) {
            log.warn("There is no handler for this event topic[{}]", (Object)event.topic());
        }
        return isOk;
    }

    private boolean handlerDo(Event event, CloudEventHandler handler) throws Throwable {
        if (CloudManager.eventInterceptor() == null) {
            return handler.handle(event);
        }
        return CloudManager.eventInterceptor().doIntercept(event, handler);
    }
}

