/*
 * Copyright 2017-2024 noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.solon.cloud.service;

import org.noear.solon.cloud.model.Pack;

import java.util.Locale;

/**
 * 云端国际化服务
 *
 * @author noear
 * @since  1.6
 */
public interface CloudI18nService {
    /**
     * 拉取语言包
     *
     * @param group    分组
     * @param packName 包名
     * @param locale   地区
     */
    Pack pull(String group, String packName, Locale locale);
}
