/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.annotation.CloudBreaker;
import org.noear.solon.cloud.fallback.Fallback;
import org.noear.solon.cloud.model.BreakerException;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;

public class CloudBreakerInterceptor
implements Interceptor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doIntercept(Invocation inv) throws Throwable {
        if (CloudClient.breaker() == null) {
            throw new IllegalArgumentException("Missing CloudBreakerService component");
        }
        CloudBreaker anno = (CloudBreaker)inv.getMethodAnnotation(CloudBreaker.class);
        if (anno == null) {
            anno = (CloudBreaker)inv.getTargetAnnotation(CloudBreaker.class);
        }
        if (anno == null) return inv.invoke();
        String name = Solon.cfg().getByTmpl(Utils.annoAlias((String)anno.value(), (String)anno.name()));
        try (AutoCloseable entry = CloudClient.breaker().entry(name);){
            Object throwable3 = inv.invoke();
            return throwable3;
        }
        catch (BreakerException ex) {
            Fallback fallback = (Fallback)inv.context().getBeanOrNew(anno.fallback());
            return fallback.fallback(inv, ex);
        }
    }
}

