/*
 * Copyright 2017-2025 noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.solon.cloud.fallback;

import org.noear.solon.cloud.exception.CloudBreakerException;
import org.noear.solon.cloud.model.BreakerException;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.handle.Context;

/**
 * 应急计划（降级处理）默认实现
 *
 * @author noear
 * @since 3.5
 */
public class FallbackThrow implements Fallback {
    @Override
    public Object fallback(Invocation invocation, BreakerException e) throws Throwable {
        Context ctx = Context.current();
        if (ctx == null) {
            //说明不是 web
            throw e;
        } else {
            //说明是 web
            throw new CloudBreakerException("Too many requests, path=" + ctx.pathNew());
            //ctx.status(429);
        }
    }
}