/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudEventInterceptor;
import org.noear.solon.cloud.CloudJobInterceptor;
import org.noear.solon.cloud.annotation.CloudConfig;
import org.noear.solon.cloud.annotation.CloudEvent;
import org.noear.solon.cloud.impl.CloudEventServiceManager;
import org.noear.solon.cloud.impl.CloudEventServiceManagerImpl;
import org.noear.solon.cloud.impl.CloudJobServiceManager;
import org.noear.solon.cloud.impl.CloudJobServiceManagerImpl;
import org.noear.solon.cloud.impl.CloudLoadBalanceFactory;
import org.noear.solon.cloud.impl.CloudLoadStrategy;
import org.noear.solon.cloud.impl.CloudLoadStrategyDefault;
import org.noear.solon.cloud.service.CloudBreakerService;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudDiscoveryServiceProxy;
import org.noear.solon.cloud.service.CloudEventService;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.cloud.service.CloudI18nService;
import org.noear.solon.cloud.service.CloudIdService;
import org.noear.solon.cloud.service.CloudIdServiceFactory;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.cloud.service.CloudListService;
import org.noear.solon.cloud.service.CloudLockService;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.solon.cloud.service.CloudMetricService;
import org.noear.solon.cloud.service.CloudMetricServiceManager;
import org.noear.solon.cloud.service.CloudTraceService;
import org.noear.solon.core.util.RankEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudManager {
    static final Logger log = LoggerFactory.getLogger(CloudManager.class);
    private static CloudLoadBalanceFactory loadBalance = new CloudLoadBalanceFactory();
    private static CloudLoadStrategy loadStrategy = new CloudLoadStrategyDefault();
    private static CloudDiscoveryService discoveryService;
    private static CloudConfigService configService;
    private static final CloudEventServiceManager eventServiceManager;
    private static CloudLockService lockService;
    private static CloudLogService logService;
    private static CloudListService listService;
    private static CloudFileService fileService;
    private static CloudI18nService i18nService;
    private static CloudBreakerService breakerService;
    private static CloudTraceService traceService;
    private static CloudMetricServiceManager metricServiceManager;
    private static CloudJobServiceManager jobServiceManager;
    private static CloudIdServiceFactory idServiceFactory;
    private static CloudIdService idServiceDef;
    protected static final Map<CloudConfig, CloudConfigHandler> configHandlerMap;
    protected static final Map<CloudEvent, CloudEventHandler> eventHandlerMap;

    protected static CloudLoadBalanceFactory loadBalance() {
        return loadBalance;
    }

    protected static CloudLoadStrategy loadStrategy() {
        return loadStrategy;
    }

    public static void register(CloudLoadStrategy loadStrategy) {
        if (loadStrategy != null) {
            CloudManager.loadStrategy = loadStrategy;
        }
    }

    public static void register(CloudConfig anno, CloudConfigHandler handler) {
        configHandlerMap.put(anno, handler);
    }

    public static void register(CloudEvent anno, CloudEventHandler handler) {
        eventHandlerMap.put(anno, handler);
    }

    public static void register(CloudBreakerService service) {
        breakerService = service;
        log.info("Cloud: CloudBreakerService registered from the " + service.getClass().getTypeName());
    }

    public static void register(CloudConfigService service) {
        configService = service;
        log.info("Cloud: CloudConfigService registered from the " + service.getClass().getTypeName());
    }

    public static void register(CloudDiscoveryService service) {
        discoveryService = new CloudDiscoveryServiceProxy(service);
        log.info("Cloud: CloudDiscoveryService registered from the " + service.getClass().getTypeName());
    }

    public static void register(CloudEventServicePlus service) {
        eventServiceManager.register(service);
        if (Utils.isEmpty((String)service.getChannel())) {
            log.info("Cloud: CloudEventService registered from the " + service.getClass().getTypeName());
        } else {
            log.info("Cloud: CloudEventService registered from the " + service.getClass().getTypeName() + " as &" + service.getChannel());
        }
    }

    public static void register(CloudLockService service) {
        lockService = service;
        log.info("Cloud: CloudLockService registered from the " + service.getClass().getTypeName());
    }

    public static void register(CloudLogService service) {
        logService = service;
        log.info("Cloud: CloudLogService registered from the " + service.getClass().getTypeName());
    }

    public static void register(CloudListService service) {
        listService = service;
        log.info("Cloud: CloudListService registered from the " + service.getClass().getTypeName());
    }

    public static void register(CloudFileService service) {
        fileService = service;
        log.info("Cloud: CloudFileService registered from the " + service.getClass().getTypeName());
    }

    public static void register(CloudI18nService service) {
        i18nService = service;
        log.info("Cloud: CloudI18nService registered from the " + service.getClass().getTypeName());
    }

    public static void register(CloudTraceService service) {
        traceService = service;
        log.info("Cloud: CloudTraceService registered from the " + service.getClass().getTypeName());
    }

    public static void register(CloudMetricService service) {
        metricServiceManager.register(service);
        log.info("Cloud: CloudMetricService registered from the " + service.getClass().getTypeName());
    }

    public static void register(CloudJobService service) {
        jobServiceManager = new CloudJobServiceManagerImpl(service);
        log.info("Cloud: CloudJobService registered from the " + service.getClass().getTypeName());
    }

    public static void register(CloudIdServiceFactory factory) {
        idServiceFactory = factory;
        idServiceDef = factory.create();
        log.info("Cloud: CloudIdServiceFactory registered from the " + factory.getClass().getTypeName());
    }

    public static void register(int index, CloudJobInterceptor jobInterceptor) {
        if (jobServiceManager != null) {
            jobServiceManager.addJobInterceptor(index, jobInterceptor);
        }
        log.info("Cloud: CloudJobInterceptor registered from the " + jobInterceptor.getClass().getTypeName());
    }

    protected static CloudBreakerService breakerService() {
        return breakerService;
    }

    protected static CloudConfigService configService() {
        return configService;
    }

    protected static CloudDiscoveryService discoveryService() {
        return discoveryService;
    }

    protected static CloudEventService eventService() {
        return eventServiceManager;
    }

    public static CloudEventInterceptor eventInterceptor() {
        if (eventServiceManager == null) {
            return null;
        }
        return eventServiceManager.getEventInterceptor();
    }

    protected static CloudLockService lockService() {
        return lockService;
    }

    protected static CloudLogService logService() {
        return logService;
    }

    protected static CloudListService listService() {
        return listService;
    }

    protected static CloudFileService fileService() {
        return fileService;
    }

    protected static CloudI18nService i18nService() {
        return i18nService;
    }

    protected static CloudTraceService traceService() {
        return traceService;
    }

    protected static CloudMetricService metricService() {
        return metricServiceManager;
    }

    protected static CloudIdServiceFactory idServiceFactory() {
        return idServiceFactory;
    }

    protected static CloudIdService idServiceDef() {
        return idServiceDef;
    }

    protected static CloudJobService jobService() {
        return jobServiceManager;
    }

    public static List<RankEntity<CloudJobInterceptor>> jobInterceptors() {
        if (jobServiceManager == null) {
            return null;
        }
        return jobServiceManager.getJobInterceptors();
    }

    static {
        eventServiceManager = new CloudEventServiceManagerImpl();
        metricServiceManager = new CloudMetricServiceManager();
        configHandlerMap = new LinkedHashMap<CloudConfig, CloudConfigHandler>();
        eventHandlerMap = new LinkedHashMap<CloudEvent, CloudEventHandler>();
    }
}

