/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.integration;

import org.noear.nami.NamiManager;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudJobHandler;
import org.noear.solon.cloud.CloudJobInterceptor;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.annotation.CloudBreaker;
import org.noear.solon.cloud.annotation.CloudConfig;
import org.noear.solon.cloud.annotation.CloudEvent;
import org.noear.solon.cloud.annotation.CloudJob;
import org.noear.solon.cloud.impl.CloudBreakerInterceptor;
import org.noear.solon.cloud.impl.CloudConfigBeanBuilder;
import org.noear.solon.cloud.impl.CloudConfigBeanInjector;
import org.noear.solon.cloud.impl.CloudEventBeanBuilder;
import org.noear.solon.cloud.impl.CloudJobBeanBuilder;
import org.noear.solon.cloud.impl.CloudJobBeanExtractor;
import org.noear.solon.cloud.impl.CloudLoadStrategy;
import org.noear.solon.cloud.impl.CloudLogAppender;
import org.noear.solon.cloud.impl.CloudTraceServiceImpl;
import org.noear.solon.cloud.impl.LocalDiscoveryResolver;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudBreakerService;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.cloud.service.CloudFileService;
import org.noear.solon.cloud.service.CloudI18nService;
import org.noear.solon.cloud.service.CloudIdServiceFactory;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.cloud.service.CloudListService;
import org.noear.solon.cloud.service.CloudLockService;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.solon.cloud.service.CloudMetricService;
import org.noear.solon.cloud.service.CloudTraceService;
import org.noear.solon.cloud.trace.HttpTraceExtension;
import org.noear.solon.cloud.trace.NamiTraceFilter;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.logging.AppenderHolder;
import org.noear.solon.logging.AppenderManager;
import org.noear.solon.logging.event.Appender;
import org.noear.solon.net.http.HttpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPlugin
implements Plugin {
    static final Logger log = LoggerFactory.getLogger(CloudPlugin.class);

    public CloudPlugin() {
        AppenderManager.register((String)"cloud", (Appender)new CloudLogAppender());
    }

    public void start(AppContext context) {
        Object builder;
        if (CloudClient.enableConfig()) {
            CloudConfigBeanInjector injector = new CloudConfigBeanInjector();
            builder = new CloudConfigBeanBuilder();
            context.beanInjectorAdd(CloudConfig.class, (BeanInjector)injector);
            context.beanBuilderAdd(CloudConfig.class, (BeanBuilder)builder);
        }
        if (CloudClient.enableEvent()) {
            CloudEventBeanBuilder builder2 = new CloudEventBeanBuilder();
            context.beanBuilderAdd(CloudEvent.class, (BeanBuilder)builder2);
        }
        if (CloudClient.enableBreaker()) {
            CloudBreakerInterceptor interceptor = new CloudBreakerInterceptor();
            context.beanInterceptorAdd(CloudBreaker.class, (Interceptor)interceptor);
        }
        if (CloudClient.enableJob()) {
            CloudJobBeanExtractor extractor = new CloudJobBeanExtractor();
            builder = new CloudJobBeanBuilder();
            context.beanExtractorAdd(CloudJob.class, (BeanExtractor)extractor);
            context.beanBuilderAdd(CloudJob.class, CloudJobHandler.class, (BeanBuilder)builder);
        }
        LocalDiscoveryResolver.register("");
        if (CloudClient.discovery() != null) {
            if (NativeDetector.isNotAotRuntime()) {
                CloudClient.discoveryPush();
            }
            context.app().factoryManager().loadBalanceFactory((LoadBalance.Factory)CloudClient.loadBalance());
        } else if (CloudClient.loadBalance().count() > 0) {
            context.app().factoryManager().loadBalanceFactory((LoadBalance.Factory)CloudClient.loadBalance());
        }
        if (CloudClient.log() != null) {
            AppenderHolder appenderHolder = AppenderManager.get((String)"cloud");
            if (appenderHolder == null) {
                AppenderManager.register((String)"cloud", (Appender)new CloudLogAppender());
            } else {
                appenderHolder.reset();
            }
        }
        if (CloudClient.trace() == null) {
            CloudManager.register(new CloudTraceServiceImpl());
        }
        if (ClassUtil.hasClass(() -> HttpConfiguration.class)) {
            HttpTraceExtension.register();
        }
        if (ClassUtil.hasClass(() -> NamiManager.class)) {
            NamiTraceFilter.register();
        }
        context.getBeanAsync(CloudLoadStrategy.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudDiscoveryService.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudConfigService.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudEventServicePlus.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudLockService.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudLogService.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudListService.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudFileService.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudI18nService.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudBreakerService.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudTraceService.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudMetricService.class, bean -> CloudManager.register(bean));
        context.getBeanAsync(CloudJobService.class, bean -> CloudManager.register(bean));
        context.subWrapsOfType(CloudJobInterceptor.class, bw -> CloudManager.register(bw.index(), (CloudJobInterceptor)bw.raw()));
        context.getBeanAsync(CloudIdServiceFactory.class, bean -> CloudManager.register(bean));
    }

    public void prestop() throws Throwable {
        if (!Solon.cfg().stopSafe()) {
            return;
        }
        if (NativeDetector.isAotRuntime()) {
            return;
        }
        if (CloudClient.discovery() != null && Utils.isNotEmpty((String)Solon.cfg().appName())) {
            for (Signal signal : Solon.app().signals()) {
                Instance instance = Instance.localNew(signal);
                CloudClient.discovery().deregister(Solon.cfg().appGroup(), instance);
                log.info("Cloud: Service deregistered " + instance.service() + "@" + instance.uri());
            }
        }
    }
}

