/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.tran;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.solon.data.tran.TranListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranListenerSet
implements TranListener {
    private static final Logger log = LoggerFactory.getLogger(TranListenerSet.class);
    private List<TranListener> listeners = new ArrayList<TranListener>();

    public void add(TranListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
            this.listeners.sort(Comparator.comparing(l -> l.getIndex()));
        }
    }

    @Override
    public void beforeCommit(boolean readOnly) throws Throwable {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).beforeCommit(readOnly);
        }
    }

    @Override
    public void beforeCompletion() {
        if (log.isTraceEnabled()) {
            log.trace("Triggering beforeCompletion listen");
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).beforeCompletion();
                continue;
            }
            catch (Throwable e) {
                log.warn("TranListener.beforeCompletion threw exception", e);
            }
        }
    }

    @Override
    public void afterCommit() {
        if (log.isTraceEnabled()) {
            log.trace("Triggering afterCommit listen");
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).afterCommit();
                continue;
            }
            catch (Throwable e) {
                log.warn("TranListener.afterCommit threw exception", e);
            }
        }
    }

    @Override
    public void afterCompletion(int status) {
        if (log.isTraceEnabled()) {
            log.trace("Triggering afterCompletion listen");
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).afterCompletion(status);
                continue;
            }
            catch (Throwable e) {
                log.warn("TranListener.afterCompletion threw exception", e);
            }
        }
    }
}

