/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.transform.chroma;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.Transformer;
import org.noear.solon.expression.snel.ComparisonNode;
import org.noear.solon.expression.snel.ComparisonOp;
import org.noear.solon.expression.snel.ConstantNode;
import org.noear.solon.expression.snel.LogicalNode;
import org.noear.solon.expression.snel.LogicalOp;
import org.noear.solon.expression.snel.VariableNode;

public class ChromaFilterTransformer
implements Transformer<Boolean, Map<String, Object>> {
    private static ChromaFilterTransformer instance = new ChromaFilterTransformer();

    public static ChromaFilterTransformer getInstance() {
        return instance;
    }

    public Map<String, Object> transform(Expression<Boolean> filterExpr) {
        if (filterExpr == null) {
            return null;
        }
        try {
            HashMap<String, Object> filter = new HashMap<String, Object>();
            this.parseFilterExpression(filterExpr, filter);
            return filter.isEmpty() ? null : filter;
        }
        catch (Exception e) {
            System.err.println("Error processing filter expression: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void parseFilterExpression(Expression<Boolean> filterExpression, Map<String, Object> result) {
        if (filterExpression == null) {
            return;
        }
        if (filterExpression instanceof VariableNode) {
            String fieldName = ((VariableNode)filterExpression).getName();
            result.put("$field", fieldName);
        } else if (filterExpression instanceof ConstantNode) {
            Object value = ((ConstantNode)filterExpression).getValue();
            Boolean isCollection = ((ConstantNode)filterExpression).isCollection();
            if (isCollection.booleanValue()) {
                result.put("$value", value);
                result.put("$isCollection", true);
            } else {
                result.put("$value", value);
            }
        } else if (filterExpression instanceof ComparisonNode) {
            ComparisonOp operator = ((ComparisonNode)filterExpression).getOperator();
            Expression left = ((ComparisonNode)filterExpression).getLeft();
            Expression right = ((ComparisonNode)filterExpression).getRight();
            HashMap<String, Object> leftMap = new HashMap<String, Object>();
            this.parseFilterExpression((Expression<Boolean>)left, leftMap);
            HashMap<String, Object> rightMap = new HashMap<String, Object>();
            this.parseFilterExpression((Expression<Boolean>)right, rightMap);
            String fieldName2 = (String)leftMap.get("$field");
            Object value2 = rightMap.get("$value");
            if (fieldName2 != null && value2 != null) {
                switch (operator) {
                    case eq: {
                        result.put(fieldName2, value2);
                        break;
                    }
                    case neq: {
                        HashMap neMap = new HashMap();
                        neMap.put("$ne", value2);
                        result.put(fieldName2, neMap);
                        break;
                    }
                    case gt: {
                        HashMap gtMap = new HashMap();
                        gtMap.put("$gt", value2);
                        result.put(fieldName2, gtMap);
                        break;
                    }
                    case gte: {
                        HashMap gteMap = new HashMap();
                        gteMap.put("$gte", value2);
                        result.put(fieldName2, gteMap);
                        break;
                    }
                    case lt: {
                        HashMap ltMap = new HashMap();
                        ltMap.put("$lt", value2);
                        result.put(fieldName2, ltMap);
                        break;
                    }
                    case lte: {
                        HashMap lteMap = new HashMap();
                        lteMap.put("$lte", value2);
                        result.put(fieldName2, lteMap);
                        break;
                    }
                    case in: {
                        HashMap inMap = new HashMap();
                        inMap.put("$in", value2);
                        result.put(fieldName2, inMap);
                        break;
                    }
                    case nin: {
                        HashMap ninMap = new HashMap();
                        ninMap.put("$nin", value2);
                        result.put(fieldName2, ninMap);
                        break;
                    }
                }
            }
        } else if (filterExpression instanceof LogicalNode) {
            LogicalOp logicalOp = ((LogicalNode)filterExpression).getOperator();
            Expression leftExpr = ((LogicalNode)filterExpression).getLeft();
            Expression rightExpr = ((LogicalNode)filterExpression).getRight();
            if (rightExpr != null) {
                HashMap<String, Object> leftMap2 = new HashMap<String, Object>();
                this.parseFilterExpression((Expression<Boolean>)leftExpr, leftMap2);
                HashMap<String, Object> rightMap2 = new HashMap<String, Object>();
                this.parseFilterExpression((Expression<Boolean>)rightExpr, rightMap2);
                switch (logicalOp) {
                    case AND: {
                        result.put("$and", Arrays.asList(leftMap2, rightMap2));
                        break;
                    }
                    case OR: {
                        result.put("$or", Arrays.asList(leftMap2, rightMap2));
                        break;
                    }
                }
            } else if (leftExpr != null) {
                HashMap<String, Object> leftMap2 = new HashMap<String, Object>();
                this.parseFilterExpression((Expression<Boolean>)leftExpr, leftMap2);
                switch (logicalOp) {
                    case NOT: {
                        result.put("$not", leftMap2);
                        break;
                    }
                }
            }
        }
    }
}

