/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.transform.milvus;

import org.noear.solon.expression.Expression;
import org.noear.solon.expression.Transformer;
import org.noear.solon.expression.snel.ComparisonNode;
import org.noear.solon.expression.snel.ConstantNode;
import org.noear.solon.expression.snel.LogicalNode;
import org.noear.solon.expression.snel.VariableNode;

public class MilvusFilterTransformer
implements Transformer<Boolean, String> {
    private static MilvusFilterTransformer instance = new MilvusFilterTransformer();

    public static MilvusFilterTransformer getInstance() {
        return instance;
    }

    public String transform(Expression<Boolean> filterExpression) {
        StringBuilder buf = new StringBuilder();
        this.parseFilterExpression(filterExpression, buf);
        return buf.toString();
    }

    private void parseFilterExpression(Expression<Boolean> filterExpression, StringBuilder buf) {
        if (filterExpression instanceof VariableNode) {
            buf.append("metadata[\"").append(((VariableNode)filterExpression).getName()).append("\"]");
        } else if (filterExpression instanceof ConstantNode) {
            Object value = ((ConstantNode)filterExpression).getValue();
            if (((ConstantNode)filterExpression).isCollection()) {
                buf.append("[");
                for (Object item : (Iterable)value) {
                    if (item instanceof String) {
                        buf.append("\"").append(item).append("\"");
                    } else {
                        buf.append(item);
                    }
                    buf.append(", ");
                }
                if (buf.length() > 1) {
                    buf.setLength(buf.length() - 1);
                }
                buf.append("]");
            } else if (value instanceof String) {
                buf.append("\"").append(value).append("\"");
            } else {
                buf.append(value);
            }
        } else if (filterExpression instanceof ComparisonNode) {
            ComparisonNode compNode = (ComparisonNode)filterExpression;
            buf.append("(");
            this.parseFilterExpression((Expression<Boolean>)compNode.getLeft(), buf);
            buf.append(" ").append(compNode.getOperator().getCode().toLowerCase()).append(" ");
            this.parseFilterExpression((Expression<Boolean>)compNode.getRight(), buf);
            buf.append(")");
        } else if (filterExpression instanceof LogicalNode) {
            LogicalNode opNode = (LogicalNode)filterExpression;
            buf.append("(");
            if (opNode.getRight() != null) {
                this.parseFilterExpression((Expression<Boolean>)opNode.getLeft(), buf);
                buf.append(" ").append(opNode.getOperator().getCode().toLowerCase()).append(" ");
                this.parseFilterExpression((Expression<Boolean>)opNode.getRight(), buf);
            } else {
                buf.append(opNode.getOperator().getCode()).append(" ");
                this.parseFilterExpression((Expression<Boolean>)opNode.getLeft(), buf);
            }
            buf.append(")");
        }
    }
}

