/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.snel.ComparisonOp;

public class ComparisonNode
implements Expression<Boolean> {
    private ComparisonOp operator;
    private Expression left;
    private Expression right;

    public ComparisonOp getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public ComparisonNode(ComparisonOp operator, Expression left, Expression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public Boolean eval(Function context) {
        Object leftValue = this.left.eval(context);
        Object rightValue = this.right.eval(context);
        switch (this.operator) {
            case gt: {
                return ((Comparable)leftValue).compareTo(rightValue) > 0;
            }
            case gte: {
                return ((Comparable)leftValue).compareTo(rightValue) >= 0;
            }
            case lt: {
                return ((Comparable)leftValue).compareTo(rightValue) < 0;
            }
            case lte: {
                return ((Comparable)leftValue).compareTo(rightValue) <= 0;
            }
            case eq: {
                return Objects.equals(leftValue, rightValue);
            }
            case neq: {
                return !Objects.equals(leftValue, rightValue);
            }
            case lk: {
                return leftValue.toString().contains(rightValue.toString());
            }
            case nlk: {
                return !leftValue.toString().contains(rightValue.toString());
            }
            case in: {
                return ((Collection)rightValue).contains(leftValue);
            }
            case nin: {
                return !((Collection)rightValue).contains(leftValue);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
    }

    public String toString() {
        return "(" + this.left + " " + this.operator.getCode() + " " + this.right + ")";
    }
}

