/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodCache {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = new HashMap();
    private final Map<MethodKey, Method> cache = new ConcurrentHashMap<MethodKey, Method>();

    public Method getMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        MethodKey key = new MethodKey(clazz, methodName, argTypes);
        return this.cache.computeIfAbsent(key, k -> this.findMethod(clazz, methodName, argTypes));
    }

    private Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        return Arrays.stream(clazz.getMethods()).filter(m -> m.getName().equals(methodName)).filter(m -> this.isMethodMatch((Method)m, argTypes)).findFirst().orElse(null);
    }

    private static Class<?> getBoxedType(Class<?> type) {
        if (type.isPrimitive()) {
            return PRIMITIVE_WRAPPER_MAP.getOrDefault(type, type);
        }
        return type;
    }

    private boolean isMethodMatch(Method method, Class<?>[] argTypes) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (this.isAssignable(paramTypes[i], argTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        if (targetType.isPrimitive()) {
            Class<?> wrapperType = PRIMITIVE_WRAPPER_MAP.get(targetType);
            return wrapperType != null && wrapperType.isAssignableFrom(sourceType);
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        return sourceType == Void.class;
    }

    static {
        PRIMITIVE_WRAPPER_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPER_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_WRAPPER_MAP.put(Boolean.TYPE, Boolean.class);
    }

    private static class MethodKey {
        private final Class<?> clazz;
        private final String methodName;
        private final Class<?>[] argTypes;

        public MethodKey(Class<?> clazz, String methodName, Class<?>[] argTypes) {
            this.clazz = clazz;
            this.methodName = methodName;
            this.argTypes = argTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            return this.clazz.equals(methodKey.clazz) && this.methodName.equals(methodKey.methodName) && Arrays.equals(this.argTypes, methodKey.argTypes);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.methodName.hashCode();
            result = 31 * result + Arrays.hashCode(this.argTypes);
            return result;
        }
    }
}

