/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.exception.EvaluationException;
import org.noear.solon.expression.snel.ConstantNode;

public class PropertyNode
implements Expression {
    private final Expression target;
    private final Expression property;

    public PropertyNode(Expression target, String property) {
        this(target, new ConstantNode(property));
    }

    public PropertyNode(Expression target, Expression property) {
        this.target = target;
        this.property = property;
    }

    public Object eval(Function context) {
        Object targetValue = this.target.eval(context);
        if (targetValue == null) {
            return null;
        }
        Object propertyValue = this.property.eval(context);
        if (propertyValue == null) {
            return null;
        }
        if (targetValue instanceof List && propertyValue instanceof Number) {
            int index = ((Number)propertyValue).intValue();
            try {
                return ((List)targetValue).get(index);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        if (targetValue.getClass().isArray() && propertyValue instanceof Number) {
            int index = ((Number)propertyValue).intValue();
            try {
                return Array.get(targetValue, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }
        String propName = propertyValue.toString();
        if (targetValue instanceof Map) {
            return ((Map)targetValue).get(propName);
        }
        return this.getPropertyValue(targetValue, propName);
    }

    public Expression getTarget() {
        return this.target;
    }

    public String getPropertyName() {
        if (this.property instanceof ConstantNode) {
            return ((ConstantNode)this.property).getValue().toString();
        }
        throw new EvaluationException("Invalid property name: " + this.property);
    }

    private Object getPropertyValue(Object target, String propName) {
        try {
            String getterName = "get" + this.capitalize(propName);
            Method getter = target.getClass().getMethod(getterName, new Class[0]);
            return getter.invoke(target, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                Field field = target.getClass().getField(propName);
                return field.get(target);
            }
            catch (NoSuchFieldException ex) {
                return null;
            }
            catch (Exception ex) {
                throw new EvaluationException("Failed to access property: " + propName, ex);
            }
        }
        catch (Exception e) {
            throw new EvaluationException("Failed to access property: " + propName, e);
        }
    }

    private String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public String toString() {
        return this.target + "[" + this.property + "]";
    }
}

